% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{testRxUnbounded}
\alias{testRxUnbounded}
\alias{assertRxUnbounded}
\alias{warnRxBounded}
\title{Test if the rxode2 model has any parameters with user defined boundaries}
\usage{
testRxUnbounded(ui)

assertRxUnbounded(ui, extra = "", .var.name = .vname(ui))

warnRxBounded(ui, extra = "", .var.name = .vname(ui))
}
\arguments{
\item{ui}{rxode2 ui}

\item{extra}{extra information to append to the error message}

\item{.var.name}{variable name}
}
\value{
boolean indicating if any parameters have user defined boundaries
}
\description{
Test if the rxode2 model has any parameters with user defined boundaries
}
\section{Functions}{
\itemize{
\item \code{assertRxUnbounded()}: Assert that the rxode2 model has any parameters with user defined boundaries

\item \code{warnRxBounded()}: Warn that the rxode2 model has any parameters with user defined boundaries

}}
\examples{

one.cmt <- function() {
  ini({
    tka <- 0.45; label("Ka")
    tcl <- log(c(0, 2.7, 100)); label("Cl")
    tv <- 3.45; label("V")
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
  })
}

testRxUnbounded(one.cmt)

try(assertRxUnbounded(one.cmt))

warnRxBounded(one.cmt)
}
\seealso{
Other Assertions: 
\code{\link{assertCompartmentExists}()},
\code{\link{assertCompartmentName}()},
\code{\link{assertCompartmentNew}()},
\code{\link{assertRxUi}()},
\code{\link{assertVariableExists}()},
\code{\link{assertVariableNew}()},
\code{\link{testIniDf}()}
}
\author{
Matthew L. Fidler
}
\concept{Assertions}
