% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topological.pseudo.ess.R
\name{topological.pseudo.ess}
\alias{topological.pseudo.ess}
\title{Calculate the pseudo Effective Sample Size (ESS) of tree topologies}
\usage{
topological.pseudo.ess(chains, burnin = 0, n = 20, treedist = "PD")
}
\arguments{
\item{chains}{A list of rwty.chain objects.}

\item{burnin}{The number of trees to eliminate as burnin}

\item{n}{The number of replicate analyses to do}

\item{treedist}{the type of tree distance metric to use, can be 'PD' for path distance or 'RF' for Robinson Foulds distance}
}
\value{
A data frame with one row per chain, and columns describing the
median ESS, the upper and lower 95% confidence intervals based on the
replicates performed, and the name of the chain.
}
\description{
This function takes a list of rwty.chain objects, and calculates the
pseudo ESS of the trees from each chain, after removing burnin. 
Each caulcation is repeated n times, where in each replicate a random
tree from the chain is chosen as a 'focal' tree. The calculation works
by calculating the path distance of each tree in the chain
from the focal tree, and calculating the ESS of the resulting vector
of phylogenetic distances using the effectiveSize function from the 
coda package. NB this function requires the calculation of many many
tree distances, so can take some time.
}
\examples{
\dontrun{
data(fungus)
topological.pseudo.ess(fungus, burnin = 20, n = 20)
}
}
\keyword{distance}
\keyword{distance,}
\keyword{path}
\keyword{tree}
\keyword{treespace,}
