% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMapExtents.R
\name{setMapExtents}
\alias{setMapExtents}
\title{Internal function allowing map extents to be set from area names}
\usage{
setMapExtents(mapRegion = "world")
}
\arguments{
\item{mapRegion}{a country name from getMap()[['NAME']] or one of
'eurasia','africa','latin america','uk','oceania','asia'}
}
\value{
a dataframe containing we,ea,so,no values in degrees between -180 &
+180
}
\description{
Allows map extents to be set from country or area names (e.g. India, Africa
)
}
\details{
Can be called by \code{\link{mapCountryData}} and
\code{\link{mapGriddedData}}
}
\examples{

mapCountryData( mapRegion='Africa' )
mapCountryData( mapRegion='India' )

}
\author{
andy south
}
\keyword{dplot}

