% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{f16qammod}
\alias{f16qammod}
\title{16-QAM Modulator}
\usage{
f16qammod(bits)
}
\arguments{
\item{bits}{- received vector of bits (0's and 1's).}
}
\value{
returns a complex vector of length = (length(bits) mod 4), 16-QAM symbols
}
\description{
Receives a vector of bits (1's and 0's). The received vector is mapped
to an in-phase (real) and quadrature (imaginary) 16-QAM (4 bit) symbol according to a
a Binary Reflective Gray Code (BRGC, see reference). Each symbol has an average
symbol energy Es = 10, where in-phase and quadrature constellation points
take on values -3, -1, +1, +3, respectively. The bit to symbol mapping is illustrated in the following constellation diagram.
\tabular{cccc}{
 -3+3i  \tab -1+3i \tab +1+3i  \tab +3+3i \cr
 (1000) \tab (1001) \tab (1011) \tab (1010) \cr
 \tab \tab \tab  \cr
 -3+1i  \tab -1+1i \tab +1+1i  \tab +3+1i \cr
 (1100) \tab (1101) \tab (1111) \tab (1110) \cr
 \tab \tab \tab  \cr
 -3-1i  \tab -1-1i \tab +1-1i  \tab +3-1i \cr
 (0100) \tab (0101) \tab (0111) \tab (0110) \cr
 \tab \tab \tab  \cr
 -3-3i  \tab -1-3i \tab +1-3i  \tab +3-3i \cr
 (0000) \tab (0001) \tab (0011) \tab (0010)
}
Reference: E. Agrell, J Lassing, E. Strom, and T. Ottosson, Gray Coding for Multilevel Constellations In Gaussian Noise, IEEE Transactions on Communications, Vol. 53, No. 1, January 2007
}
\examples{
M=16
Nsymbols=100
Nbits=log2(M)*Nsymbols
bits <- sample(0:1,Nbits, replace=TRUE)
s <- f16qammod(bits)
}
\seealso{
Other modulation.demodulation.communications: \code{\link{f16pskdemod}};
  \code{\link{f16pskmod}}; \code{\link{f16qamdemod}};
  \code{\link{f64qamdemod}}; \code{\link{f64qammod}};
  \code{\link{f8pskdemod}}; \code{\link{f8pskmod}};
  \code{\link{fNo}}; \code{\link{fbpskdemod}};
  \code{\link{fbpskmod}}; \code{\link{fqpskdemod}};
  \code{\link{fqpskmod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}
}

