% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rwa.R
\name{plot_rwa}
\alias{plot_rwa}
\title{Plot the rescaled importance values from the output of \code{rwa()}}
\usage{
plot_rwa(rwa)
}
\arguments{
\item{rwa}{Direct list output from \code{rwa()}.}
}
\description{
Pass the output of \code{rwa()} and plot a bar chart of the rescaled importance values.
Signs are always calculated and taken into account, which is equivalent to setting the \code{applysigns}
argument to \code{TRUE} in \code{rwa()}.
}
\examples{

library(ggplot2)
diamonds \%>\%
  rwa(outcome = "price",
      predictors = c("depth","carat", "x", "y", "z"),
      applysigns = TRUE) \%>\%
  plot_rwa()


}
