% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinecop_methods.R
\name{mBICV}
\alias{mBICV}
\title{Modified vine copula Bayesian information criterion (mBICv)}
\usage{
mBICV(object, psi0 = 0.9, newdata = NULL)
}
\arguments{
\item{object}{a fitted \code{vinecop} object.}

\item{psi0}{baseline prior probability of a non-independence copula.}

\item{newdata}{optional; a new data set.}
}
\description{
Calculates the modified vine copula Bayesian information criterion.
}
\details{
The modified vine copula Bayesian information criterion (mBICv) is defined as

\deqn{BIC = -2 loglik +  \nu log(n) - 2 \sum_{t=1}^{d - 1} (q_t log(\psi_0^t)
- (d - t - q_t) log(1 - \psi_0^t)) }

where \eqn{\mathrm{loglik}} is the log-likelihood and \eqn{\nu} is the
(effective) number of parameters of the model, \eqn{t} is the tree level
\eqn{\psi_0} is the prior probability of having a non-independence copula and
\eqn{q_t} is the number of non-independence copulas in tree \eqn{t}. The
mBICv is a consistent model selection criterion for parametric sparse vine
copula models.
}
\examples{
u <- sapply(1:5, function(i) runif(50))
fit <- vinecop(u, family = "par", keep_data = TRUE)
mBICV(fit, 0.9) # with a 0.9 prior probability of a non-independence copula
mBICV(fit, 0.1) # with a 0.1 prior probability of a non-independence copula
}
\references{
Nagler, T., Bumann, C., Czado, C. (2019). Model selection for
sparse high-dimensional vine copulas with application to portfolio risk.
\emph{Journal of Multivariate Analysis, in press}
(\url{http://arxiv.org/pdf/1801.09739})
}
