% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinecop_methods.R
\name{vinecop_predict_and_fitted}
\alias{vinecop_predict_and_fitted}
\alias{predict.vinecop}
\alias{fitted.vinecop}
\alias{fitted.vinecop}
\title{Predictions and fitted values for a vine copula model}
\usage{
\method{predict}{vinecop}(object, newdata, what = "pdf", n_mc = 10^4, ...)

\method{fitted}{vinecop}(object, what = "pdf", n_mc = 10^4, ...)
}
\arguments{
\item{object}{a \code{vinecop} object.}

\item{newdata}{points where the fit shall be evaluated.}

\item{what}{what to predict, either \code{"pdf"} or \code{"cdf"}.}

\item{n_mc}{number of samples used for quasi Monte Carlo integration when
\code{what = "cdf"}.}

\item{...}{unused.}
}
\value{
\code{fitted()} and \code{predict()} have return values similar to \code{\link[=dvinecop]{dvinecop()}}
and \code{\link[=pvinecop]{pvinecop()}}.
}
\description{
Predictions of the density and distribution function
for a vine copula model.
}
\examples{
u <- sapply(1:5, function(i) runif(50))
fit <- vinecop(u, "par")
all.equal(predict(fit, u), fitted(fit))
}
