% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_variational.R
\name{variational_block}
\alias{variational_block}
\title{Create a variational block of layers}
\usage{
variational_block(units, epsilon_std = 1, seed = NULL)
}
\arguments{
\item{units}{Number of units}

\item{epsilon_std}{Standard deviation for the normal distribution used for sampling}

\item{seed}{A seed for the random number generator. \strong{Setting a seed is required if you
want to save the model and be able to load it correctly}}
}
\value{
A construct with class \code{"ruta_layer"}
}
\description{
This variational block consists in two dense layers which take as input the previous layer
and a sampling layer. More specifically, these layers aim to represent the mean and the
log variance of the learned distribution in a variational autoencoder.
}
\examples{
variational_block(3)
}
\seealso{
\code{\link{autoencoder_variational}}

Other neural layers: \code{\link{dense}},
  \code{\link{dropout}}, \code{\link{input}},
  \code{\link{layer_keras}}, \code{\link{output}}
}
