% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Moex.R
\name{getSymbols.Moex}
\alias{getSymbols.Moex}
\title{Get financial data from MOEX Exchange}
\usage{
getSymbols.Moex(
  Symbols,
  env = globalenv(),
  from = "2007-01-01",
  to = Sys.Date(),
  adjust = FALSE,
  period = "day",
  market = NULL,
  verbose = FALSE,
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{character vector of ticker symbols to retrieve data for}

\item{env}{environment where data is stored}

\item{from}{character string specifying the start date (default: '2007-01-01')}

\item{to}{character string specifying the end date (default: Sys.Date())}

\item{adjust}{logical flag indicating whether to adjust prices for dividends and splits (default: FALSE)}

\item{period}{character string specifying the interval of the data ('day', 'hour', '10min', or '1min'; default: 'day')}

\item{market}{character string specifying the market of the data (default: NULL)}

\item{verbose}{logical flag indicating whether to print progress messages (default: FALSE)}

\item{auto.assign}{logical flag indicating whether to automatically assign the resulting data to objects with the same names as Symbols (default: FALSE)}

\item{...}{Additional arguments.}
}
\value{
xts object with historical data
}
\description{
Retrieves historical data of a stock from Moscow Exchange (MOEX) using its API.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
data <- getSymbols.Moex('GAZP', from='2022-01-01', to='2022-01-10', period='day', auto.assign=FALSE)
}
\author{
Vyacheslav Arbuzov
}
