% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_anc.R
\name{rtry_select_anc}
\alias{rtry_select_anc}
\title{Select ancillary data in wide table format}
\usage{
rtry_select_anc(input, id, showOverview = TRUE)
}
\arguments{
\item{input}{Input data frame or data table.}

\item{id}{The ID of the ancillary data (\code{DataID} in the TRY data) to be selected.}

\item{showOverview}{Default \code{TRUE} displays the dimension and column names of the selected data.}
}
\value{
An object of the same type as the input data.
}
\description{
This function selects one specified ancillary data together with the \code{ObservationID}
from the imported data and transforms it into a wide table format for further processing.
It works for only one ancillary data in \code{DataID} at a time.
}
\examples{
# Obtain a list of ObservationID and the corresponding ancillary data of interest
# using the specified DataID (e.g. DataID 59 for latitude) from the provided sample
# data (e.g. data_TRY_15160)
lat <- rtry_select_anc(data_TRY_15160, 59)

# Expected message:
# dim:   98 2
# col:   ObservationID Latitude
}
\references{
This function makes use of the \code{\link[base]{subset}} and \code{\link[dplyr]{distinct}} functions
within the \code{base} and \code{dplyr} packages respectively. It also uses the functions
\code{\link{rtry_select_col}} and \code{\link{rtry_remove_col}}.
}
