% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cg_memberbystatedistrict.R
\name{cg_memberbystatedistrict}
\alias{cg_memberbystatedistrict}
\title{Get a list of the most recent new members of the current Congress.}
\usage{
cg_memberbystatedistrict(chamber = NULL, state = NULL, district = NULL,
  key = NULL, ...)
}
\arguments{
\item{chamber}{One of 'house' or 'senate.}

\item{state}{Limits the list of members by state; two-letter state code (e.g., CA).}

\item{district}{Limits the list of members by district (House only). If you specify
a district, you must also specify a state. If the district number you
specify is higher than the total number of districts for that state,
a 404 response will be returned.}

\item{key}{your New York Times API key; pass in, or loads from .Rprofile as
\code{nytimes_cg_key}, or from .Renviron as \code{NYTIMES_CG_KEY}}

\item{...}{Curl options (debugging tools mostly) passed to \code{\link[httr]{GET}}}
}
\value{
List of new members of he current Congress.
}
\description{
Get a list of the most recent new members of the current Congress.
}
\examples{
\dontrun{
cg_memberbystatedistrict(chamber='senate', state='NH')
}
}

