% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{string_to_table}
\alias{string_to_table}
\title{Split character string into table}
\usage{
string_to_table(x, n, split_regex = ", ?")
}
\arguments{
\item{x}{string to split and convert to table}

\item{n}{number of bucket to create. It will be the number of column in the
resulting data.frame}

\item{split_regex}{defaults to \verb{, ?}. Pass to \code{split} in \code{\link[base:strsplit]{base::strsplit()}}.}
}
\value{
a dataframe of \code{n} columns
}
\description{
It takes a character string with names separated by comma (e.g. journal's names)
and turns them into a table
}
\details{
If the number of elements can't be split equally in the \code{n} column, blank
cells will be created and all placed in the last column.
}
\examples{
string_to_table(paste(letters, collapse = ", "), 3)
}
