% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copernicus_article.R
\name{copernicus_article}
\alias{copernicus_article}
\alias{copernicus_journal_abbreviations}
\title{Copernicus journals format.}
\usage{
copernicus_article(
  ...,
  keep_tex = TRUE,
  highlight = NULL,
  citation_package = "natbib",
  md_extensions = c("-autolink_bare_uris", "-auto_identifiers")
)

copernicus_journal_abbreviations(journal_name = "*")
}
\arguments{
\item{...}{Additional arguments to \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document()}}. \strong{Note}: \code{extra_dependencies} are not
allowed as Copernicus does not support additional packages included via \code{\\usepackage{}}.}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{highlight}{Syntax highlighting style passed to Pandoc.

 Supported built-in styles include "default", "tango", "pygments", "kate",
 "monochrome", "espresso", "zenburn", "haddock", and "breezedark".

  Two custom styles are also included, "arrow", an accessible color scheme,
  and "rstudio", which mimics the default IDE theme. Alternatively, supply a
  path to a \samp{.theme} file to use
  \href{https://pandoc.org/MANUAL.html#syntax-highlighting}{a custom Pandoc
  style}. Note that custom theme requires Pandoc 2.0+.

  Pass \code{NULL} to prevent syntax highlighting.}

\item{citation_package}{The LaTeX package to process citations, \code{natbib}
or \code{biblatex}. Use \code{default} if neither package is to be used,
which means citations will be processed via the command
\command{pandoc-citeproc}.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition of R Markdown. See the \code{\link[rmarkdown]{rmarkdown_format}} for
additional details.}

\item{journal_name}{A regular expression to filter the by the journal name, see \code{pattern} in \code{\link[base:grep]{base::grep()}}; defaults to \code{*}.}
}
\value{
An R Markdown output format.
}
\description{
Format for creating submissions to Copernicus journals.
}
\details{
This was adapted from
\url{https://publications.copernicus.org/for_authors/manuscript_preparation.html}.

An number of required and optional manuscript sections, e.g. \code{acknowledgements}, \code{competinginterests}, or \code{authorcontribution}, must be declared using the respective properties of the R Markdown header - see skeleton file.

\strong{Version:} Based on \code{copernicus_package.zip} in the version 6.7, 16 March 2022, using \code{copernicus.cls} in version 9.46, 25 March  2022.

\strong{Copernicus journal abbreviations:} You can use the function \code{copernicus_journal_abbreviations()} to get the journal abbreviation for all journals supported by the Copernicus article template.

\strong{Important note:} The online guidelines by Copernicus are the official resource.
Copernicus is not responsible for the community contributions made to support the template in this package.
Copernicus converts all typeset TeX files into XML, the expressions and markups have to be highly standardized.
Therefore, please keep the following in mind:
\itemize{
\item Please provide only one figure file for figures with several panels, and please do not use \verb{\\subfloat} or similar commands.
\item Please use only commands in which words, numbers, etc. are within braces (e.g. \verb{\\textrm\{TEXT\}} instead of \verb{\\rm TEXT}).
\item For algorithms, please use the syntax given in template.tex or provide your algorithm as a figure.
\item Please do not define new commands.
\item Supported packages (\verb{\\usepackage\{\}}) are already integrated in the \code{copernicus.cls}.  Please do not insert additional ones in your \code{.tex} file.
\item If you opt for syntax highlighting for your preprint or other reasons, please do not forget to use
\code{highlight = NULL} for your final file upload once your manuscript was accepted for publication.
\item Spaces in labels (\verb{\\label\{\}}) are not allowed; please make sure that no label name is assigned more than once.
\item Please do not use \verb{\\paragraph\{\}}; only \verb{\\subsubsection\{\}} is allowed.
\item It is not possible to add tables in colour.
}
}
\note{
If you use \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document()}}, all internal references (i.e. tables and figures) must use \verb{\\ref\{\}} whereas with \code{\link[bookdown:html_document2]{bookdown::pdf_document2()}}, you can additionally use \verb{\\@ref()}.
}
\examples{
names(copernicus_journal_abbreviations())
copernicus_journal_abbreviations(journal_name = "Science Data")
\dontrun{
library("rmarkdown")
draft("MyArticle.Rmd", template = "copernicus", package = "rticles")
render("MyArticle/MyArticle.Rmd")
}
}
\references{
Manuscript preparation guidelines for authors.
\url{https://publications.copernicus.org/for_authors/manuscript_preparation.html}
}
