% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_export.R
\name{export_as_docx}
\alias{export_as_docx}
\alias{section_properties_default}
\alias{margins_potrait}
\alias{margins_landscape}
\title{Export as word document}
\usage{
export_as_docx(
  tt,
  file,
  doc_metadata = NULL,
  titles_as_header = FALSE,
  footers_as_text = TRUE,
  template_file = NULL,
  section_properties = section_properties_default(),
  ...
)

section_properties_default(
  page_size = c("letter", "A4"),
  orientation = c("portrait", "landscape")
)

margins_potrait()

margins_landscape()
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{file}{(\code{string})\cr string that indicates the final file output. Must have \code{.docx} extension.}

\item{doc_metadata}{(\code{list} of \code{string}s)\cr any value that can be used as metadata by
\code{?officer::set_doc_properties}. Important text values are \code{title}, \code{subject}, \code{creator}, and \code{description},
while \code{created} is a date object.}

\item{titles_as_header}{(\code{flag})\cr defaults to \code{TRUE} for \code{\link[=tt_to_flextable]{tt_to_flextable()}}, so the table is self-contained
as it makes additional header rows for \code{\link[formatters:title_footer]{formatters::main_title()}} string and \code{\link[formatters:title_footer]{formatters::subtitles()}} character
vector (one per element). \code{FALSE} is suggested for \code{\link[=export_as_docx]{export_as_docx()}}. This adds titles and subtitles as a text
paragraph above the table. The same style is applied.}

\item{footers_as_text}{(\code{flag})\cr defaults to \code{FALSE} for \code{\link[=tt_to_flextable]{tt_to_flextable()}}, so the table is self-contained with
the \code{flextable} definition of footnotes. \code{TRUE} is used for \code{\link[=export_as_docx]{export_as_docx()}} to add the footers as a new
paragraph after the table. The same style is applied, but with a smaller font.}

\item{template_file}{(\code{string})\cr template file that \code{officer} will use as a starting point for the final
document. Document attaches the table and uses the defaults defined in the template file.}

\item{section_properties}{(\code{officer::prop_section})\cr an \code{\link[officer:prop_section]{officer::prop_section()}} object which sets margins and
page size. Defaults to \code{section_properties_default()}.}

\item{...}{(\code{any})\cr additional arguments passed to \code{\link[=tt_to_flextable]{tt_to_flextable()}}.}

\item{page_size}{(\code{character(1)}) page size. Can be \code{"letter"} or \code{"A4"}. Defaults to \code{"letter"}.}

\item{orientation}{(\code{character(1)}) page orientation. Can be \code{"portrait"} or \code{"landscape"}. Defaults to
\code{"portrait"}.}
}
\description{
From a table, produce a self-contained word document or attach it to a template word
file (\code{template_file}). This function is based on the \code{\link[=tt_to_flextable]{tt_to_flextable()}} transformer and
the \code{officer} package.
}
\section{Functions}{
\itemize{
\item \code{section_properties_default()}: Helper function that defines standard portrait properties for tables.

\item \code{margins_potrait()}: Helper function that defines standard portrait margins for tables.

\item \code{margins_landscape()}: Helper function that defines standard landscape margins for tables.

}}
\note{
\code{export_as_docx()} has few customization options available. If you require specific formats and details,
we suggest that you use \code{\link[=tt_to_flextable]{tt_to_flextable()}} prior to \code{export_as_docx}. Only the \code{title_as_header} and
\code{footer_as_text} parameters must be re-specified if the table is changed first using \code{\link[=tt_to_flextable]{tt_to_flextable()}}.
}
\examples{
\dontshow{if (require(flextable)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(flextable)
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2", "COUNTRY"))

tbl <- build_table(lyt, ex_adsl)

# See how section_properties_portrait function is built for custom
tf <- tempfile(fileext = ".docx")
export_as_docx(tbl,
  file = tf,
  section_properties = section_properties_default(orientation = "landscape")
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tt_to_flextable]{tt_to_flextable()}}
}
