% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{basic_table}
\alias{basic_table}
\title{Layout with 1 column and zero rows}
\usage{
basic_table(
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character()
)
}
\arguments{
\item{title}{character(1). Main title. Ignored for subtables.}

\item{subtitles}{character. Subtitles. Ignored for subtables.}

\item{main_footer}{character. Main global (non-referential) footer materials.}

\item{prov_footer}{character. Provenance-related global footer materials. Generally should not be modified by hand.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{build_table}.
}
\description{
Every layout must start with a basic table.
}
\examples{

lyt <- basic_table() \%>\%
  analyze("AGE", afun = mean)

build_table(lyt, DM)

}
