% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_paginate.R
\name{pag_tt_indices}
\alias{pag_tt_indices}
\alias{paginate_table}
\title{Pagination of a TableTree}
\usage{
pag_tt_indices(
  tt,
  lpp = 15,
  min_siblings = 2,
  nosplitin = character(),
  colwidths = NULL,
  verbose = FALSE
)

paginate_table(
  tt,
  lpp = 15,
  min_siblings = 2,
  nosplitin = character(),
  colwidths = NULL,
  verbose = FALSE
)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{lpp}{numeric. Maximum lines per page including (re)printed header and context rows}

\item{min_siblings}{numeric. Minimum sibling rows which must appear on either side of pagination row for a
mid-subtable split to be valid. Defaults to 2.}

\item{nosplitin}{character. List of names of sub-tables where page-breaks are not allowed, regardless of other
considerations. Defaults to none.}

\item{colwidths}{numeric vector. Column widths for use with vertical pagination. Currently ignored.}

\item{verbose}{logical(1). Should extra debugging messages be shown. Defaults to \code{FALSE}.}
}
\value{
for \code{pag_tt_indices} a list of paginated-groups of row-indices of \code{tt}. For \code{paginate_table},
The subtables defined by subsetting by the indices defined by \code{pag_tt_indices}.
}
\description{
Pagination of a TableTree
}
\note{
This is our first take on pagination. We will refine pagination in subsequent releases. Currently only
pagination in the row space work. Pagination in the column space will be added in the future.
}
\examples{

s_summary <- function(x) {
 if (is.numeric(x)) {
     in_rows(
         "n" = rcell(sum(!is.na(x)), format = "xx"),
         "Mean (sd)" = rcell(c(mean(x, na.rm = TRUE), sd(x, na.rm = TRUE)),
                             format = "xx.xx (xx.xx)"),
         "IQR" = rcell(IQR(x, na.rm = TRUE), format = "xx.xx"),
         "min - max" = rcell(range(x, na.rm = TRUE), format = "xx.xx - xx.xx")
     )
 } else if (is.factor(x)) {

     vs <- as.list(table(x))
     do.call(in_rows, lapply(vs, rcell, format = "xx"))

 } else (
     stop("type not supported")
 )
}


lyt <- basic_table() \%>\%
split_cols_by(var = "ARM") \%>\%
    analyze(c("AGE", "SEX", "BEP01FL", "BMRKR1", "BMRKR2", "COUNTRY"), afun = s_summary)

tbl <- build_table(lyt, ex_adsl)
tbl

nrow(tbl)

row_paths_summary(tbl)

tbls <- paginate_table(tbl)

w_tbls <- propose_column_widths(tbl) # so that we have the same column widths

tmp <- lapply(tbls, print, widths = w_tbls)

tmp <- lapply(tbls, function(tbli) {
  cat(toString(tbli, widths = w_tbls))
  cat("\n\n")
  cat("~~~~ PAGE BREAK ~~~~")
  cat("\n\n")
})


}
