% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FlexPivot.R
\name{FlexPivot}
\alias{FlexPivot}
\title{creates a FlexTable by transposing variables}
\usage{
FlexPivot(dataset, id, transpose, columns, columns.transpose = T,
  color = character(0), background.color = character(0), space.table = F,
  column.label = "Stat.")
}
\arguments{
\item{dataset}{a tidy data.frame.}

\item{id}{variable whose values are used to identify transposed variables}

\item{transpose}{transpose each \code{columns} by \code{transpose} groups}

\item{columns}{variables to transpose}

\item{columns.transpose}{transpose also \code{columns}}

\item{color}{optional, font color, named character vector, names are specifying
which element of \code{columns} to colorize and values column names
that contains color values to use.}

\item{background.color}{optional, cell background color, named character vector,
names are specifying which element of \code{columns} to colorize and values
column names that contains color values to use.}

\item{space.table}{add a space after each group}

\item{column.label}{label for column name of stacked \code{columns} when
\code{columns.transpose} is \code{FALSE}}
}
\value{
a \code{\link{FlexTable}} object
}
\description{
creates a \code{\link{FlexTable}} by transposing variables into observations.
}
\examples{
#
# load ggplot2
if( require("dplyr", quietly = TRUE) ){
	
	data = mtcars
	data = group_by(data, vs, am, gear, carb)
	data = summarise(data, avg = mean( mpg ), min = min( mpg ))

	data$avg_col = ifelse( data$avg < 17, "red", "black" )
	data$min_col = ifelse( data$min < 20, "gray", "purple" )
	
	data$avg = sprintf( "\%.3f", data$avg)
	data$min = sprintf( "\%.2f", data$min)
	
	
	ft = FlexPivot( dataset = data, space = FALSE, columns.transpose = TRUE, 
		id = c("gear", "carb"), transpose = c("vs", "am"), 
		columns = c("avg", "min"), 
		color = c("avg"="avg_col", "min" = "min_col") )
	print( ft )
	if( interactive() ) readline("Hit <Return> to see next FlexTable:")
	
	
	ft = FlexPivot( dataset = data, space = TRUE, columns.transpose = TRUE, 
			id = c("gear", "carb"), transpose = c("vs", "am"), 
			columns = c("avg", "min") )
	print( ft )
	if( interactive() ) readline("Hit <Return> to see next FlexTable:")
	
	
	ft = FlexPivot( dataset = data, space = FALSE, columns.transpose = FALSE, 
			id = c("gear", "carb"), transpose = c("vs", "am"), 
			columns = c("avg", "min") )
	print( ft )
	if( interactive() ) readline("Hit <Return> to see next FlexTable:")
	
	
	ft = FlexPivot( dataset = data, space = TRUE, 
			columns.transpose = FALSE, 
			id = c("gear", "carb"), 
			transpose = c("vs", "am"), 
			columns = c("avg", "min")
	)
	print( ft )
	
}
}

