% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_annotations.r
\name{cast_text}
\alias{cast_text}
\title{Cast annotations to text}
\usage{
cast_text(tokens, annotation, ..., text_col = "token", na.rm = T)
}
\arguments{
\item{tokens}{A tokenIndex}

\item{annotation}{The name of annotations (the "column" argument in annotate_tqueries)}

\item{...}{Optionally, group annotations together. Named arguments can be given
where the name is the new group, and the value is a character vector with
values in the annotation column. For example, text = c('verb','predicate') would 
group the 'verb' and 'predicate' nodes together under the name 'text'.}

\item{text_col}{The name of the column in tokens with the text. Usually this is "token",
but some parsers use alternatives such as 'word'.}

\item{na.rm}{If true (default), drop tokens where annotation id is NA (i.e. tokens without labels)}
}
\value{
a data.table
}
\description{
Cast labeled tokens to sentences.
}
\examples{
tokens = tokens_spacy[tokens_spacy$doc_id == 'text3',]

## two simple example tqueries
passive = tquery(pos = "VERB*", label = "verb", fill=FALSE,
                 children(relation = "agent",
                          children(label="subject")),
                 children(relation = "nsubjpass", label="object"))
active =  tquery(pos = "VERB*", label = "verb", fill=FALSE,
                 children(relation = c("nsubj", "nsubjpass"), label = "subject"),
                 children(relation = "dobj", label="object"))

tokens = annotate_tqueries(tokens, "clause", pas=passive, act=active, overwrite=T)

cast_text(tokens, 'clause')

## group annotations
cast_text(tokens, 'clause', text = c('verb','object'))

## use grouping to sort
cast_text(tokens, 'clause', subject = 'subject', 
                            verb = 'verb', object = 'object')
}
