% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssimLibrary.R
\name{ssimLibrary}
\alias{ssimLibrary}
\alias{ssimLibrary,SsimObject-method}
\alias{ssimLibrary,missingOrNULLOrChar-method}
\title{Create or open a library}
\usage{
ssimLibrary(
  name = NULL,
  summary = NULL,
  package = NULL,
  session = NULL,
  addon = NULL,
  forceUpdate = FALSE,
  overwrite = FALSE
)

\S4method{ssimLibrary}{SsimObject}(
  name = NULL,
  summary = NULL,
  package = NULL,
  session = NULL,
  addon = NULL,
  forceUpdate = FALSE,
  overwrite = FALSE
)

\S4method{ssimLibrary}{missingOrNULLOrChar}(
  name = NULL,
  summary = NULL,
  package = NULL,
  session = NULL,
  addon = NULL,
  forceUpdate = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{name}{Character string, Project/Scenario/SsimLibrary. The path to a library or SsimObject.}

\item{summary}{Logical. Default TRUE.}

\item{package}{Character. The package type. The default is "stsim".}

\item{session}{Session. If NULL, session() will be used.}

\item{addon}{Character or character vector. One or more addons. See addon() for options.}

\item{forceUpdate}{Logical. If FALSE (default) user will be prompted to approve any required updates. If TRUE, required updates will be applied silently.}

\item{overwrite}{Logical. If TRUE an existing Library will be overwritten.}
}
\value{
Returns a \code{SsimLibrary} object.
}
\description{
Creates or opens a \code{\link{SsimLibrary}} object.
If summary = TRUE, returns library summary info.
If summary = NULL, returns library summary info if ssimObject is a SsimLibrary, SsimLibrary object otherwise.
}
\details{
\itemize{
  \item {If name is SyncroSim Project or Scenario: }{Returns the \code{\link{SsimLibrary}} associated with the Project or Scenario.}
  \item {If name is NULL: }{Create/open a SsimLibrary in the current working directory with the filename SsimLibrary.ssim.}
  \item {If name is a string: }{If string is not a valid path treat as filename in working directory. If no file suffix provided in string then add .ssim. Attempts to open a library of that name. If library does not exist creates a library of type package in the current working directory.}
  \item {If given a name and a package: }{Create/open a library called <name>.ssim. Returns an error if the library already exists but is a different type of package.}
}
}
\examples{
\donttest{
# Create or open a library using the default session
myLibrary <- ssimLibrary(name = file.path(tempdir(), "mylib"))

# Create library using a specific session
mySession <- session()
myLibrary <- ssimLibrary(name = file.path(tempdir(), "mylib"), session = mySession)

session(myLibrary)
filepath(myLibrary)
info(myLibrary)
}

}
