/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeProvider;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.formula.FormulaBooleanElement;
import org.vikamine.kernel.formula.FormulaElement;
import org.vikamine.kernel.persistence.FormulaUnmarshaller;
import org.vikamine.kernel.persistence.SelectorPersistenceManager;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.BooleanFormulaTarget;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.subgroup.target.SelectorTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class XMLPersistenceReader {
    private Ontology ontology;

    public XMLPersistenceReader(Ontology onto) {
        this.ontology = onto;
    }

    public Document readXML(File theFile) throws IOException {
        FileInputStream in = new FileInputStream(theFile);
        try {
            Document document = this.readXML(in);
            return document;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private Document parseXml(InputStream in) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fac.newDocumentBuilder();
        return builder.parse(in);
    }

    public Document readXML(InputStream in) throws IOException {
        try {
            Document doc = this.parseXml(in);
            this.processDocument(doc);
            return doc;
        }
        catch (FactoryConfigurationError e) {
            IOException ex = new IOException(e.getMessage());
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "readXML", ex);
            throw ex;
        }
        catch (ParserConfigurationException e) {
            IOException ex = new IOException(e.getMessage());
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "readXML", ex);
            throw ex;
        }
        catch (SAXException e) {
            IOException ex = new IOException(e.getMessage());
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "readXML", ex);
            throw ex;
        }
        catch (IOException e) {
            IOException ex = new IOException(e.getMessage());
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "readXML", ex);
            throw e;
        }
    }

    public abstract void processDocument(Document var1) throws IOException;

    protected List parseSelectorList(Node node, AttributeProvider attributeProvider) {
        LinkedList<SGSelector> selectors = new LinkedList<SGSelector>();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                try {
                    SGSelector selector = new SelectorPersistenceManager().unmarshall((Element)child, attributeProvider, this.ontology);
                    selectors.add(selector);
                }
                catch (ParseException e) {
                    Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "error at parsing selector", e);
                }
            }
            ++i;
        }
        return selectors;
    }

    protected List parseSubgroups(Node parent, AttributeProvider attributeProvider) throws IOException {
        NodeList children = parent.getChildNodes();
        LinkedList<SG> subgroups = new LinkedList<SG>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                if (!"sg".equals(child.getNodeName())) {
                    IOException e = new IOException("Wrong element: " + child.getNodeName() + " (expected: 'sg')");
                    Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "parseSubgroups", e);
                    throw e;
                }
                SG sg = this.parseSGNode((Element)child, attributeProvider);
                subgroups.add(sg);
            }
            ++i;
        }
        return subgroups;
    }

    protected SG parseSGNode(Element parent, AttributeProvider attributeProvider) throws IOException {
        NodeList children = parent.getChildNodes();
        SGTarget target = null;
        SGDescription desc = new SGDescription();
        LinkedList<SGSelector> populationSelectors = new LinkedList<SGSelector>();
        DataView population = this.ontology.getDataView().createPopulation(populationSelectors);
        SG sg = new SG(population, target, desc);
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                Element elem = (Element)node;
                if ("target".equals(node.getNodeName())) {
                    target = this.parseTarget(elem, attributeProvider);
                } else if ("description".equals(node.getNodeName())) {
                    for (SGNominalSelector select : this.parseSelectorList(node, attributeProvider)) {
                        desc.add(select);
                    }
                } else if ("population".equals(node.getNodeName())) {
                    Iterator iter = this.parseSelectorList(node, attributeProvider).iterator();
                    while (iter.hasNext()) {
                        populationSelectors.add((SGSelector)iter.next());
                    }
                }
            }
            ++i;
        }
        population = this.ontology.getDataView().createPopulation(populationSelectors);
        sg.setPopulation(population);
        sg.setTarget(target);
        return sg;
    }

    protected SGTarget parseTarget(Element elem, AttributeProvider attributeProvider) throws IOException {
        String type = elem.getAttribute("type");
        if (type.equals("emptyTarget")) {
            return null;
        }
        if ("selector".equals(type)) {
            List selectorList = this.parseSelectorList(elem, attributeProvider);
            if (selectorList.isEmpty()) {
                IOException e = new IOException("Missing target for Subgroup");
                Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "parseTarget", e);
                throw e;
            }
            if (selectorList.size() != 1) {
                IOException e = new IOException("wrong number of selectors in SelectorTarget: " + selectorList.size());
                Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "parseTarget", e);
                throw e;
            }
            return new SelectorTarget((SGNominalSelector)selectorList.get(0));
        }
        if ("booleanFormula".equals(type)) {
            NodeList formulaNodes = elem.getChildNodes();
            int j = 0;
            while (j < formulaNodes.getLength()) {
                Node child = formulaNodes.item(j);
                if (child instanceof Element && "formula".equals(child.getNodeName())) {
                    FormulaElement formula = new FormulaUnmarshaller(this.ontology).unmarshal((Element)child, attributeProvider);
                    return new BooleanFormulaTarget((FormulaBooleanElement)formula);
                }
                ++j;
            }
            IOException e = new IOException("missing formula for FormulaTarget");
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "parseTarget", e);
            throw e;
        }
        if ("numeric".equals(type)) {
            String attributeID = elem.getAttribute("variable");
            NumericAttribute targetAttribute = (NumericAttribute)this.getOntology().getAttribute(attributeID);
            if (targetAttribute == null) {
                IOException e = new IOException("targetVariable for NumericTarget not found! ");
                Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "parseTarget", e);
                throw e;
            }
            return new NumericTarget(targetAttribute);
        }
        IOException e = new IOException("unknown target-type: " + type);
        Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "parseTarget", e);
        throw e;
    }

    protected Attribute getDMAttribute(String attributeString) {
        return this.ontology.getAttribute(attributeString);
    }

    private void setBooleanOption(Options.Option option, Options options, Element el) {
        String attribtueString = el.getAttribute("attribute");
        Attribute attribute = this.getDMAttribute(attribtueString);
        if (attribute != null) {
            Boolean bValue = Boolean.valueOf(el.getAttribute("value"));
            options.setBooleanAttributeOption(attribute, option, bValue);
        }
    }

    protected Options parseOptions(Node node) throws IOException {
        Options options = new Options();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                if (!"option".equals(child.getNodeName())) {
                    IOException e = new IOException("Wrong element: " + child.getNodeName() + " (expected: 'option')");
                    Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "parseOptions", e);
                    throw e;
                }
                Element el = (Element)child;
                String type = el.getAttribute("id");
                if (type.equals(Options.TREAT_MISSING_NOT_AS_DEFINED_VALUE.getId())) {
                    this.setBooleanOption(Options.TREAT_MISSING_NOT_AS_DEFINED_VALUE, options, el);
                }
            }
            ++i;
        }
        return options;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    protected void setOntology(Ontology onto) {
        this.ontology = onto;
    }
}

