% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_interval.R
\name{posterior_interval.stanreg}
\alias{posterior_interval}
\alias{posterior_interval.stanreg}
\title{Posterior uncertainty intervals}
\usage{
\method{posterior_interval}{stanreg}(object, prob = 0.9, type = "central",
  pars = NULL, regex_pars = NULL, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals. The default is to report
\eqn{90}\% intervals (\code{prob=0.9}) rather than the traditionally used
\eqn{95}\% (see Details).}

\item{type}{The type of interval to compute. Currently the only option is
\code{"central"} (see Details). A central \eqn{100p}\%
interval is defined by the \eqn{\alpha/2} and \eqn{1 - \alpha/2} quantiles,
where \eqn{\alpha = 1 - p}.}

\item{pars}{An optional character vector of parameter names.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}

\item{...}{Currently ignored.}
}
\value{
A matrix with two columns and as many rows as model parameters (or
  the subset of parameters specified by \code{pars} and/or
  \code{regex_pars}). For a given value of \code{prob}, \eqn{p}, the columns
  correspond to the lower and upper \eqn{100p}\% interval limits and have the
  names \eqn{100\alpha/2}\% and \eqn{100(1 - \alpha/2)}\%, where \eqn{\alpha
  = 1-p}. For example, if \code{prob=0.9} is specified (a \eqn{90}\%
  interval), then the column names will be \code{"5\%"} and \code{"95\%"},
  respectively.
}
\description{
For models fit using MCMC (\code{algorithm="sampling"}) or one of the
variational approximations (\code{"meanfield"} or \code{"fullrank"}), the
\code{posterior_interval} function computes Bayesian posterior uncertainty
intervals. These intervals are often referred to as \emph{credible}
intervals, but we use the term \emph{uncertainty} intervals to highlight the
fact that wider intervals correspond to greater uncertainty.
}
\details{
\subsection{Interpretation}{
Unlike for a frenquentist confidence interval, it is valid to say that,
conditional on the data and model, we believe that with probability \eqn{p}
the value of a parameter is in its \eqn{100p}\% posterior interval. This
intuitive interpretation of Bayesian intervals is often erroneously applied
to frequentist confidence intervals. See Morey et al. (2015) for more details
on this issue and the advantages of using Bayesian posterior uncertainty
intervals (also known as credible intervals).
}
\subsection{Default 90\% intervals}{
We default to reporting \eqn{90}\% intervals rather than \eqn{95}\% intervals
for several reasons:
\itemize{
 \item Computational stability: \eqn{90}\% intervals are more stable than
 \eqn{95}\% intervals (for which each end relies on only \eqn{2.5}\% of the
 posterior draws). \item Relation to Type-S errors (Gelman and Carlin, 2014):
 \eqn{95}\% of the mass in a \eqn{90}\% central interval is above the lower
 value (and \eqn{95}\% is below the upper value). For a parameter
 \eqn{\theta}, it is therefore easy to see if the posterior probability that
 \eqn{\theta > 0} (or \eqn{\theta < 0}) is larger or smaller than \eqn{95}\%.
}
Of course, if \eqn{95}\% intervals are desired they can be computed by
specifying \code{prob=0.95}.
}
\subsection{Types of intervals}{
Currently \code{posterior_interval} only computes central intervals because
other types of intervals are rarely useful for the models that \pkg{rstanarm}
can estimate. Additional possibilities may be provided in future releases as
more models become available.
}
}
\examples{
if (!exists("example_model")) example(example_model)
posterior_interval(example_model)
posterior_interval(example_model, regex_pars = "herd")
posterior_interval(example_model, pars = "period2", prob = 0.5)

}
\references{
Gelman, A. and Carlin, J. (2014). Beyond power calculations:
assessing Type S (sign) and Type M (magnitude) errors. \emph{Perspectives on
Psychological Science}. 9(6), 641--51.

Morey, R. D., Hoekstra, R., Rouder, J., Lee, M. D., and Wagenmakers, E. 
(2016). The fallacy of placing confidence in confidence intervals. 
\emph{Psychonomic Bulletin & Review}. 23(1), 103--123.
}
\seealso{
\code{\link{confint.stanreg}}, which, for models fit using optimization, can
be used to compute traditional confidence intervals.

\code{\link{predictive_interval}} for predictive intervals.
}

