% Generated by roxygen2 (4.0.2): do not edit by hand
\name{without_back.rdeque}
\alias{without_back.rdeque}
\title{Return a version of an rdeque without the back element}
\usage{
\method{without_back}{rdeque}(d, ...)
}
\arguments{
\item{d}{rdeque to remove elements from.}

\item{...}{additional arguments to be passed to or from methods (ignored).}
}
\value{
version of the rdeque with the back element removed.
}
\description{
Simply returns a version of the given rdeque without the back element
The original rdeque is left alone.
}
\details{
Runs in \eqn{O(1)}-amortized time if the rdeque is used non-persistently (see documentation
of \code{\link{rdeque}} for details). If the given rdeque is empty, an error will be generated.
}
\examples{
d <- rdeque()
d <- insert_front(d, "a")
d <- insert_front(d, "b")
d <- insert_front(d, "c")

d2 <- without_back(d)
print(d2)

d3 <- without_back(d)
print(d3)

print(d)
}
\references{
Okasaki, Chris. Purely Functional Data Structures. Cambridge University Press, 1999.
}
\seealso{
\code{\link{insert_back}} for inserting elements.
}

