% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{get_request}
\alias{get_request}
\alias{post_request}
\title{STAC API request functions}
\usage{
get_request(q, ...)

post_request(q, ..., encode = c("json", "multipart", "form"))
}
\arguments{
\item{q}{a \code{RSTACQuery} object expressing a STAC query
criteria.}

\item{...}{config parameters to be passed to \link[httr]{GET} or
\link[httr]{POST} methods, such as \link[httr]{add_headers} or
\link[httr]{set_cookies}.}

\item{encode}{a \code{character} informing the request body
Content-Type. Accepted types are \code{'json'} (\code{'application/json'}),
\code{'form'} (\code{'application/x-www-form-urlencoded'}),
and \code{'multipart'} (\code{'multipart/form-data'}). Defaults to
\code{'json'}.}
}
\value{
Either a \code{STACCatalog}, \code{STACCollection},
\code{STACCollectionList}, \code{STACItemCollection} or \code{STACItem}
object depending on the subclass and search fields parameters of \code{q}
argument.
}
\description{
The \code{get_request} is function that makes HTTP GET
requests to STAC web services, retrieves, and parse the data.

The \code{post_request} is function that makes HTTP POST
requests to STAC web services, retrieves, and parse the data.
}
\examples{
\donttest{
stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
 get_request()

stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1") \%>\%
 post_request()
}
}
\seealso{
\code{\link{stac}} \code{\link{stac_search}} \code{\link{collections}}
\code{\link{items}}
}
