% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{assets_list}
\alias{assets_list}
\title{Utility functions}
\usage{
assets_list(items, assets_names, sort = TRUE, gdal_vsi_resolution = TRUE)
}
\arguments{
\item{items}{a \code{STACItemCollection} object representing
the result of \code{/stac/search}, \code{/collections/{collectionId}/items}.}

\item{assets_names}{a \code{character} with the assets names to be
filtered.}

\item{sort}{a \code{logical} if true the dates will be sorted
in increasing order. By default, the dates are sorted.}

\item{gdal_vsi_resolution}{a \code{logical}  if true, gdal drivers are
included in the URL of each asset. The following schemes are supported:
HTTP/HTTPS files, S3 (AWS S3) and GS (Google Cloud Storage).}
}
\value{
a \code{list} with the attributes of date, bands and paths.
}
\description{
This function returns the \code{date}, \code{band} and
 \code{URL} fields for each assets of an \code{STACItemCollection} object.
 For the URL you can add the GDAL library drivers for the following schemes:
 HTTP/HTTPS files, S3 (AWS S3) and GS (Google Cloud Storage).
}
\examples{
\donttest{
# STACItemCollection object
stac_item <- stac("http://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
 get_request() \%>\% items_fetch(progress = FALSE)

stac_item \%>\% assets_list(assets_names = c("EVI", "NDVI"))
}

}
