/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.rscala.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.ddahl.rscala.server.Debugger;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3Q!\u0001\u0002\u0001\t)\u0011AbU2bY\u0006\u001cvnY6fiNT!a\u0001\u0003\u0002\rM,'O^3s\u0015\t)a!\u0001\u0004sg\u000e\fG.\u0019\u0006\u0003\u000f!\tQ\u0001\u001a3bQ2T\u0011!C\u0001\u0004_J<7C\u0001\u0001\f!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fM\"A!\u0003\u0001B\u0001B\u0003%A#A\u0007q_J$8OR5mK:\fW.Z\u0002\u0001!\t)\u0002D\u0004\u0002\r-%\u0011q#D\u0001\u0007!J,G-\u001a4\n\u0005eQ\"AB*ue&twM\u0003\u0002\u0018\u001b!AA\u0004\u0001B\u0001B\u0003%Q$\u0001\u0003q_J$\bC\u0001\u0007\u001f\u0013\tyRBA\u0002J]RD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\tI\u0016\u0014WoZ4feB\u00111\u0005J\u0007\u0002\u0005%\u0011QE\u0001\u0002\t\t\u0016\u0014WoZ4fe\")q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"B!\u000b\u0016,YA\u00111\u0005\u0001\u0005\u0006%\u0019\u0002\r\u0001\u0006\u0005\u00069\u0019\u0002\r!\b\u0005\u0006C\u0019\u0002\rA\t\u0005\b]\u0001\u0011\r\u0011\"\u00010\u0003!\u0019XM\u001d<fe&sW#\u0001\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014a\u00018fi*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u00051\u0019VM\u001d<feN{7m[3u\u0011\u0019I\u0004\u0001)A\u0005a\u0005I1/\u001a:wKJLe\u000e\t\u0005\bw\u0001\u0011\r\u0011\"\u00010\u0003%\u0019XM\u001d<fe>+H\u000f\u0003\u0004>\u0001\u0001\u0006I\u0001M\u0001\u000bg\u0016\u0014h/\u001a:PkR\u0004\u0003bB \u0001\u0005\u0004%\t\u0001Q\u0001\tg>\u001c7.\u001a;J]V\t\u0011\t\u0005\u00022\u0005&\u00111I\r\u0002\u0007'>\u001c7.\u001a;\t\r\u0015\u0003\u0001\u0015!\u0003B\u0003%\u0019xnY6fi&s\u0007\u0005C\u0004H\u0001\t\u0007I\u0011\u0001%\u0002\u0005%tW#A%\u0011\u0005)kU\"A&\u000b\u00051#\u0014AA5p\u0013\tq5JA\bECR\f\u0017J\u001c9viN#(/Z1n\u0011\u0019\u0001\u0006\u0001)A\u0005\u0013\u0006\u0019\u0011N\u001c\u0011\t\u000fI\u0003!\u0019!C\u0001\u0001\u0006I1o\\2lKR|U\u000f\u001e\u0005\u0007)\u0002\u0001\u000b\u0011B!\u0002\u0015M|7m[3u\u001fV$\b\u0005C\u0004W\u0001\t\u0007I\u0011A,\u0002\u0007=,H/F\u0001Y!\tQ\u0015,\u0003\u0002[\u0017\n\u0001B)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u00079\u0002\u0001\u000b\u0011\u0002-\u0002\t=,H\u000f\t")
public class ScalaSockets {
    private final ServerSocket serverIn;
    private final ServerSocket serverOut;
    private final Socket socketIn;
    private final DataInputStream in;
    private final Socket socketOut;
    private final DataOutputStream out;

    public ServerSocket serverIn() {
        return this.serverIn;
    }

    public ServerSocket serverOut() {
        return this.serverOut;
    }

    public Socket socketIn() {
        return this.socketIn;
    }

    public DataInputStream in() {
        return this.in;
    }

    public Socket socketOut() {
        return this.socketOut;
    }

    public DataOutputStream out() {
        return this.out;
    }

    public ScalaSockets(String portsFilename, int port, Debugger debugger) {
        this.serverIn = new ServerSocket(port, 1, InetAddress.getByName(null));
        this.serverOut = new ServerSocket(port == 0 ? 0 : port + 1, 1, InetAddress.getByName(null));
        if (debugger.value()) {
            debugger.msg(new StringBuilder().append((Object)"Trying to open ports filename: ").append((Object)portsFilename).toString());
        }
        File portNumberFile = new File(portsFilename);
        PrintWriter p = new PrintWriter(portNumberFile);
        p.println(new StringBuilder().append(this.serverIn().getLocalPort()).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)this.serverOut().getLocalPort())).toString());
        p.close();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        if (debugger.value()) {
            debugger.msg(new StringBuilder().append((Object)"Servers are running on port ").append((Object)BoxesRunTime.boxToInteger((int)this.serverIn().getLocalPort())).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)this.serverOut().getLocalPort())).toString());
        }
        this.socketIn = this.serverIn().accept();
        this.socketIn().setTcpNoDelay(true);
        this.in = new DataInputStream(new BufferedInputStream(this.socketIn().getInputStream()));
        this.socketOut = this.serverOut().accept();
        this.socketOut().setTcpNoDelay(true);
        this.out = new DataOutputStream(new BufferedOutputStream(this.socketOut().getOutputStream()));
    }
}

