% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataQuery.R
\name{dataQuery}
\alias{dataQuery}
\title{dataQuery}
\usage{
dataQuery(xy = xy, st = NULL, img = img, rt = NULL, type = NULL,
  bs = NULL, rd = FALSE, fun = NULL)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{st}{Object of class \emph{Date} with \emph{xy} observation dates.}

\item{img}{Object of class \emph{RasterLayer}, \emph{RasterStack} or \emph{RasterBrick}.}

\item{rt}{Object of class \emph{Date} with \emph{img} observation dates.}

\item{type}{One of \emph{exact} or \emph{nearest}.}

\item{bs}{Buffer size (unit depends on the raster projection).}

\item{rd}{Logical. Should the function ignore duplicated pixels? Default if FALSE.}

\item{fun}{Passes an external function.}
}
\value{
A SpatialPointsDataDataFrame.
}
\description{
Query environmental data for coordinate pairs.
}
\details{
{Returns environmental variables from a raster object for a given set of x and y coordinates.
         A buffer size (\emph{bs}) and a user defined function (\emph{fun}) can be specified to sample within an 
         area. The defaut is to estimate a weighted mean. If acquisition times are provided (\emph{rt}) the 
         raster data is treated as a time series. In this case, the function applies 
         one of two sampling approaches: \emph{exact} or \emph{nearest}. If \emph{exact}, the function attempts to map the 
         dates of the raster time series with the observation dates of the samples (\emph{ot}). If nearest, 
         it searches for the nearest time step. If \emph{rd} is set, the function will account for duplicated 
         pixels. The samples will be transposed to pixel coordinates and, for each unique pixel, median 
         coordinates will be estimated for each pixel and used to build the output shapefile.}
}
\examples{
{
 
 require(rgdal)
 require(raster)
 require(sp)
 
 # read movement data
 file <- system.file('extdata', 'konstanz_20130805-20130811.shp', package="rsMove")
 moveData <- shapefile(file)
 
 # read remote sensing data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'tc.*tif', full.names=TRUE)
 rsStk <- stack(file)
 
 # retrieve remote sensing data for samples
 rsQuery <- dataQuery(xy=moveData,img=rsStk)

}

}
\seealso{
\code{\link{sampleMove}} \code{\link{backSample}}
}
