/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockConverter;
import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.page.Page;
import java.nio.ByteBuffer;

public final class Block {
    private final Long id;
    private boolean readOnly = false;
    private boolean modified = false;
    private final ByteBuffer byteBuffer;
    private ByteBuffer underlyingByteBuffer;

    public Block(long id, ByteBuffer byteBuffer) {
        this((Long)id, byteBuffer);
    }

    public Block(Long id, ByteBuffer byteBuffer) {
        this.id = id;
        this.byteBuffer = byteBuffer;
        this.readOnly = false;
        this.modified = false;
        this.underlyingByteBuffer = null;
    }

    public <T extends Page> T convert(BlockConverter<T> converter) {
        return converter.fromBlock(this);
    }

    public final Long getId() {
        return this.id;
    }

    public final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readonly) {
        if (readonly && this.modified) {
            throw new BlockException("Attempt to mark a modified block as read-only");
        }
        this.readOnly = readonly;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        if (this.readOnly && modified) {
            throw new BlockException("Attempt to mark a readonly block as modified");
        }
        this.modified = modified;
    }

    public ByteBuffer getUnderlyingByteBuffer() {
        return this.underlyingByteBuffer;
    }

    public void setUnderlyingByteBuffer(ByteBuffer underlyingByteBuffer) {
        this.underlyingByteBuffer = underlyingByteBuffer;
    }

    public String toString() {
        ByteBuffer bb = this.getByteBuffer();
        return String.format("Block: %d (posn=%d, limit=%d, cap=%d)", this.id, bb.position(), bb.limit(), bb.capacity());
    }

    public Block replicate() {
        ByteBuffer dstBuffer = Block.replicate(this.getByteBuffer());
        Block b = new Block(this.getId(), dstBuffer);
        b.modified = this.modified;
        b.readOnly = this.readOnly;
        return b;
    }

    public static void replicate(Block srcBlock, Block dstBlock) {
        if (!srcBlock.getId().equals(dstBlock.getId())) {
            throw new BlockException("FileAccessMem: Attempt to copy across blocks: " + srcBlock.getId() + " => " + dstBlock.getId());
        }
        Block.replicate(srcBlock.getByteBuffer(), dstBlock.getByteBuffer());
    }

    private static ByteBuffer replicate(ByteBuffer srcBlk) {
        ByteBuffer dstBlk = ByteBuffer.allocate(srcBlk.capacity());
        int x = srcBlk.position();
        int y = srcBlk.limit();
        srcBlk.clear();
        if (srcBlk.hasArray() && dstBlk.hasArray()) {
            System.arraycopy(srcBlk.array(), 0, dstBlk.array(), 0, srcBlk.capacity());
        } else {
            dstBlk.put(srcBlk);
        }
        srcBlk.position(x);
        dstBlk.position(x);
        srcBlk.limit(y);
        dstBlk.limit(y);
        return dstBlk;
    }

    private static void replicate(ByteBuffer srcBlk, ByteBuffer dstBlk) {
        srcBlk.position(0);
        dstBlk.position(0);
        dstBlk.put(srcBlk);
    }
}

