/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io;

import java.util.Stack;
import org.openjena.atlas.json.JsonArray;
import org.openjena.atlas.json.JsonBoolean;
import org.openjena.atlas.json.JsonNull;
import org.openjena.atlas.json.JsonNumber;
import org.openjena.atlas.json.JsonObject;
import org.openjena.atlas.json.JsonString;
import org.openjena.atlas.json.JsonValue;
import org.openjena.atlas.json.io.JSONHandler;
import org.openjena.atlas.lib.InternalErrorException;
import org.openjena.atlas.logging.Log;

public class JSONMaker
implements JSONHandler {
    private JsonValue value = null;
    private Stack<JsonArray> arrays = new Stack();
    private Stack<JsonObject> objects = new Stack();
    private Stack<String> keys = new Stack();

    public JsonValue jsonValue() {
        return this.value;
    }

    public void startParse() {
    }

    public void finishParse() {
    }

    public void startObject() {
        this.objects.push(new JsonObject());
    }

    public void finishObject() {
        this.value = this.objects.pop();
    }

    public void startArray() {
        this.arrays.push(new JsonArray());
    }

    public void element() {
        this.arrays.peek().add(this.value);
        this.value = null;
    }

    public void finishArray() {
        this.value = this.arrays.pop();
    }

    public void startPair() {
    }

    public void keyPair() {
        this.keys.push(this.value.getAsString().value());
    }

    public void finishPair() {
        if (this.value == null) {
            throw new InternalErrorException("null for 'value' (bad finishPair() allignment)");
        }
        String k = this.keys.pop();
        JsonObject obj = this.objects.peek();
        if (obj.hasKey(k)) {
            Log.warn("JSON", "Duplicate key '" + k + "' for object");
        }
        obj.put(k, this.value);
        this.value = null;
    }

    public void valueBoolean(boolean b) {
        this.value = new JsonBoolean(b);
    }

    public void valueDecimal(String image) {
        this.value = JsonNumber.valueDecimal(image);
    }

    public void valueDouble(String image) {
        this.value = JsonNumber.valueDouble(image);
    }

    public void valueInteger(String image) {
        this.value = JsonNumber.valueInteger(image);
    }

    public void valueNull() {
        this.value = JsonNull.instance;
    }

    public void valueString(String image) {
        this.value = new JsonString(image);
    }
}

