% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialize.R
\name{materialize_sql_statement}
\alias{materialize_sql_statement}
\title{Create materialize statement.}
\usage{
materialize_sql_statement(db, sql, table_name, ..., temporary = FALSE)
}
\arguments{
\item{db}{DBI connecton.}

\item{sql}{character single SQL statement.}

\item{table_name}{character, name of table to create.}

\item{...}{force later arguments to bind by name.}

\item{temporary}{logical if TRUE try to create a temporary table.}
}
\value{
modified SQL
}
\description{
Create materialize statement.
}
\examples{

if(requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  print(materialize_sql_statement(my_db,
                                  "SELECT x+1 FROM z",
                                  "restable"))
  DBI::dbDisconnect(my_db)
}

}
