% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi_ops.R
\name{getDBOption}
\alias{getDBOption}
\title{Set a database connection option.}
\usage{
getDBOption(db, optname, default)
}
\arguments{
\item{db}{DBI database connection handle.}

\item{optname}{character, single option name.}

\item{default}{what to return if not set.}
}
\value{
option value
}
\description{
Set a database connection option.
}
\examples{

if(requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  print(getDBOption(my_db, "use_DBI_dbExecute"))
  DBI::dbDisconnect(my_db)
}

}
