% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialize.R
\name{materialize}
\alias{materialize}
\title{Materialize an optree as a table.}
\usage{
materialize(optree, db, table_name = mkTempNameGenerator("rquery_mat"), ...,
  overwrite = FALSE, temporary = TRUE)
}
\arguments{
\item{optree}{relop operation tree.}

\item{db}{DBI connecton.}

\item{table_name}{character, name of table to create.}

\item{...}{force later arguments to bind by name.}

\item{overwrite}{logical if TRUE drop an previous table.}

\item{temporary}{logical if TRUE try to create a temporary table.}
}
\value{
table handle
}
\description{
Run the data query as a CREATE TABLE AS . Think of as a function
that can be applied to relop trees, not as a component to place
in pipelines.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d <- dbi_copy_to(my_db, 'd',
                data.frame(AUC = 0.6, R2 = 0.2))
optree <- extend_se(d, c("v" := "AUC + R2", "x" := "pmax(AUC,v)"))
cat(format(optree))
res <- materialize(optree, my_db, "example")
cat(format(res))
sql <- to_sql(res, my_db)
cat(sql)
DBI::dbGetQuery(my_db, sql)
DBI::dbDisconnect(my_db)

}
