% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_opal.R
\name{get_course_results}
\alias{get_course_results}
\title{Get zip with course results by resource id and node id}
\usage{
get_course_results(
  resource_id,
  node_id,
  path = ".",
  rename = TRUE,
  api_user = NULL,
  api_password = NULL,
  endpoint = NULL
)
}
\arguments{
\item{resource_id}{A length one character vector with resource id.}

\item{node_id}{A length one character vector with node id (test).}

\item{path}{A length one character vector with path, where the zip should be
stored. Default is working directory.}

\item{rename}{A boolean value; optional; Set \code{TRUE} value to take the short
name of the course element for naming zip (results_shortName.zip). \code{FALSE}
combines in zip name course id and node id. Default is \code{TRUE}.}

\item{api_user}{A character value of the username in the OPAL.}

\item{api_password}{A character value of the password in the OPAL.}

\item{endpoint}{A string of endpoint of LMS Opal; by default it is got from
environment variable \code{RQTI_API_ENDPOINT}. To set a global environment
variable, you need to call
\code{Sys.setenv(RQTI_API_ENDPOINT='xxxxxxxxxxxxxxx')} or you can put these
command into .Renviron.}
}
\value{
It downloads a zip and return a character string with path.
}
\description{
Get zip with course results by resource id and node id
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
zip_file <- get_course_results("89068111333293", "1617337826161777006")
\dontshow{\}) # examplesIf}
}
