library(rpf)
library(testthat)

# Windows 32bit fails on this test. If you figure out
# why, let me know.
if (Sys.info()[['sysname']] == "Windows") q()

context("extremes")

test_that("param info", {
  ans1 <- structure(list(0L, NA_real_, 1e-06, 0L, NA_real_, 1e-06, 1L,
                         NA_real_, NA_real_, 2L, 0.999999, 1e-06, 2L, 0.999999, 1e-06),
                    .Dim = c(3L,  5L), .Dimnames = list(c("type", "upper", "lower"), NULL))
  expect_identical(rpf.paramInfo(rpf.drm(factors=2)), ans1)
  
  ans2 <- structure(list(0L, NA_real_, 1e-06, 0L, NA_real_, 1e-06, 1L,
                         NA_real_, NA_real_, 1L, NA_real_, NA_real_),
                    .Dim = 3:4, .Dimnames = list(     c("type", "upper", "lower"), NULL))
  expect_identical(rpf.paramInfo(rpf.grm(outcomes=3, factors=2)), ans2)
  
  ans3 <- structure(list(0L, NA_real_, 1e-06, 0L, NA_real_, 1e-06, 0L,
                         NA_real_, NA_real_, 0L, NA_real_, NA_real_, 0L, NA_real_,
                         NA_real_, 1L, NA_real_, NA_real_, 1L, NA_real_, NA_real_,
                         1L, NA_real_, NA_real_),
                    .Dim = c(3L, 8L), .Dimnames = list(     c("type", "upper", "lower"), NULL))
  expect_identical(rpf.paramInfo(rpf.nrm(outcomes=4, factors=2)), ans3)
})

spec <- list()
param <- list()
# repair the poor version of drm TODO
#spec [[length(spec) +1]] <- rpf.drm(poor=TRUE)
#param[[length(param)+1]] <- c(1, 0, 0)
spec [[length(spec) +1]] <- rpf.drm(multidimensional=TRUE)
param[[length(param)+1]] <- c(1, 0, .05, .95)

spec [[length(spec) +1]] <- rpf.grm(3, multidimensional=TRUE)
param[[length(param)+1]] <- c(1, 1, -1)

spec [[length(spec) +1]] <- rpf.nrm(3)
param[[length(param)+1]] <- c(1,  .5, .6, 0, -.6)

# To debug, set breakpoint on Rf_error 
where <- seq(-1000, 1000, 100)
for (ix in 1:length(spec)) {
  ispec <- spec[[ix]]
  iparam <- param[[ix]]
  test_that(paste("extreme values in", class(ispec)), {
    for (wh in where) {
      v <- rpf.prob(ispec, iparam, wh)
      expect_equal(sum(v), 1)
    }
    for (wh in where) {
      v <- rpf.logprob(ispec, iparam, wh)
      expect_equal(sum(exp(v)), 1)
    }
    w <- rchisq(ispec@outcomes, df=6)
    for (wh in where) rpf.dLL(ispec, iparam, wh, w)
  })
}

for (ix in 1:length(spec)) {
  ispec <- spec[[ix]]
  iparam <- param[[ix]]
  test_that(paste("score=NA", class(ispec)), {
    v <- rpf.prob(ispec, iparam, as.numeric(c(NA,NA)))
    expect_true(all(is.na(v)))
    v <- rpf.logprob(ispec, iparam, as.numeric(c(NA,NA)))
    expect_true(all(is.na(v)))
  })
}
