first_time <- function(path) {
  generated <- dir(file.path(path, "man"), full.names = TRUE)
  generated <- generated[!file.info(generated)$isdir]

  namespace <- file.path(path, "NAMESPACE")
  if (file.exists(namespace)) {
    generated <- c(generated, namespace)
  }

  roxy <- vapply(generated, made_by_roxygen, logical(1))
  all(!roxy)
}

made_by_roxygen <- function(path) {
  if (!file.exists(path)) return(TRUE)

  first <- readLines(path, n = 1)
  check_made_by(first)
}

add_made_by_roxygen <- function(path, comment) {
  if (!file.exists(path)) stop("Can't find ", path, call. = FALSE)

  lines <- readLines(path, warn = FALSE)
  if (check_made_by(lines[1])) return()

  writeLines(c(made_by(comment), lines), path)
}

check_made_by <- function(first) {
  if (length(first) == 0L) return(FALSE)
  grepl("^. Generated by roxygen2", first)
}

made_by <- function(comment) {
  paste0(comment, " Generated by roxygen2 (", packageVersion("roxygen2"),
    "): do not edit by hand\n")
}
