% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{taxonomy_taxon_info}
\alias{flags.taxon_info}
\alias{is_suppressed.taxon_info}
\alias{ott_id.taxon_info}
\alias{synonyms.taxon_info}
\alias{tax_name.taxon_info}
\alias{tax_rank.taxon_info}
\alias{tax_sources.taxon_info}
\alias{taxonomy_taxon_info}
\alias{unique_name.taxon_info}
\title{Taxon information}
\usage{
taxonomy_taxon_info(ott_ids, include_children = FALSE,
  include_lineage = FALSE, include_terminal_descendants = FALSE, ...)

\method{tax_rank}{taxon_info}(tax, ...)

\method{tax_name}{taxon_info}(tax, ...)

\method{unique_name}{taxon_info}(tax, ...)

\method{synonyms}{taxon_info}(tax, ...)

\method{ott_id}{taxon_info}(tax, ...)

\method{tax_sources}{taxon_info}(tax, ...)

\method{is_suppressed}{taxon_info}(tax, ...)

\method{flags}{taxon_info}(tax, ...)
}
\arguments{
\item{ott_ids}{the ott ids of the taxon of interest (numeric or
character containing only numbers)}

\item{include_children}{whether to include information about all
the children of this taxon. Default \code{FALSE}.}

\item{include_lineage}{whether to include information about all
the higher level taxa that include the \code{ott_ids}.
Default \code{FALSE}.}

\item{include_terminal_descendants}{whether to include the list of
terminal \code{ott_ids} contained in the \code{ott_ids}
provided.}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}

\item{tax}{an object generated by the \code{taxonomy_taxon_info}
function}
}
\value{
\code{taxonomy_taxon_info} returns a list detailing
    information about the taxa. \code{tax_rank} and
    \code{tax_name} return a vector. \code{synonyms} returns a
    list whose elements are the synonyms for each of the
    \code{ott_id} requested.
}
\description{
Information about taxa.
}
\details{
Given a vector of ott ids, \code{taxonomy_taxon_info} returns
information about the specified taxa.

The functions \code{tax_rank}, \code{tax_name}, and
\code{synonyms} can extract this information from an object
created by the \code{taxonomy_taxon_info()}.
}
\examples{
\dontrun{
req <- taxonomy_taxon_info(ott_id=515698)
tax_rank(req)
tax_name(req)
synonyms(req)
}
}
\seealso{
\code{\link{tnrs_match_names}} to obtain \code{ott_id}
    from a taxonomic name.
}

