/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.libror;

import fi.smaa.libror.FullValueFunction;
import fi.smaa.libror.PartialValueFunction;
import fi.smaa.libror.RORModel;
import fi.smaa.libror.RandomUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.random.MersenneTwister;

public class GeneralValueFunctionSampler
extends RORModel {
    private FullValueFunction[] vfs;
    private MersenneTwister rng = new MersenneTwister(1639);
    private double[] w = new double[this.getNrCriteria()];
    private int misses;

    public GeneralValueFunctionSampler(RealMatrix perfMatrix, int count) {
        super(perfMatrix);
        this.vfs = new FullValueFunction[count];
    }

    public void sample() {
        this.misses = 0;
        for (int i = 0; i < this.vfs.length; ++i) {
            FullValueFunction vf;
            while (true) {
                if (this.isHit(vf = this.sampleValueFunction())) break;
                ++this.misses;
            }
            this.vfs[i] = vf;
        }
    }

    public int getMisses() {
        return this.misses;
    }

    private boolean isHit(FullValueFunction vf) {
        double[] values = new double[this.getNrAlternatives()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = vf.evaluate(this.perfMatrix.getRow(i));
        }
        for (RORModel.PrefPair p : this.prefPairs) {
            if (!(values[p.a] < values[p.b])) continue;
            return false;
        }
        return true;
    }

    public FullValueFunction[] getValueFunctions() {
        if (this.vfs == null) {
            throw new IllegalStateException("sample() not called");
        }
        return this.vfs;
    }

    private FullValueFunction sampleValueFunction() {
        int i;
        FullValueFunction vf = new FullValueFunction();
        ArrayList<double[]> partVals = new ArrayList<double[]>();
        ArrayList<double[]> partEvals = new ArrayList<double[]>();
        for (i = 0; i < this.getNrCriteria(); ++i) {
            double[] vals = this.levels[i].getData();
            partVals.add(vals);
            partEvals.add(this.createPartialValues(vals.length));
        }
        RandomUtil.createSumToOneRand(this.w);
        for (i = 0; i < this.getNrCriteria(); ++i) {
            double[] evals = (double[])partEvals.get(i);
            int j = 0;
            while (j < evals.length) {
                int n = j++;
                evals[n] = evals[n] * this.w[i];
            }
            vf.addValueFunction(new PartialValueFunction((double[])partVals.get(i), evals));
        }
        return vf;
    }

    private double[] createPartialValues(int length) {
        double[] vals = new double[length];
        vals[0] = 0.0;
        for (int i = 1; i < vals.length - 1; ++i) {
            vals[i] = this.rng.nextDouble();
        }
        vals[vals.length - 1] = 1.0;
        Arrays.sort(vals);
        return vals;
    }
}

