% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_historical_weather.R
\name{get_historical_weather}
\alias{get_historical_weather}
\title{Download point-level historical weather (ERA5) using open-meteo API}
\usage{
get_historical_weather(
  latitude,
  longitude,
  site_id = NULL,
  start_date,
  end_date,
  variables = c("relative_humidity_2m", "precipitation", "wind_speed_10m", "cloud_cover",
    "temperature_2m", "shortwave_radiation")
)
}
\arguments{
\item{latitude}{latitude degree north}

\item{longitude}{longitude degree east}

\item{site_id}{name of site location (optional, default = NULL)}

\item{start_date}{earliest date requested. Must be on or after 1950-01-01}

\item{end_date}{latest date requested}

\item{variables}{vector of name of variable(s) https://open-meteo.com/en/docs/ensemble-api}
}
\value{
data frame with the results from the call to the open-meteo API.  The data frame is in a long format and has the following columns: "datetime", "site_id", "model_id", "variable", "prediction","unit".
}
\description{
Download point-level historical weather (ERA5) using open-meteo API
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_historical_weather(
latitude = 37.30,
longitude = -79.83,
start_date = "2023-01-01",
end_date = Sys.Date(),
variables = c("temperature_2m"))
\dontshow{\}) # examplesIf}
}
