% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_scale}
\alias{roll_scale}
\title{Rolling Scaling and Centering}
\usage{
roll_scale(
  x,
  width,
  weights = rep(1, width),
  center = TRUE,
  scale = TRUE,
  min_obs = width,
  complete_obs = FALSE,
  na_restore = FALSE,
  online = TRUE
)
}
\arguments{
\item{x}{vector or matrix. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{weights}{vector. Weights for each observation within a window.}

\item{center}{logical. If \code{TRUE} then the weighted mean of each variable is used,
if \code{FALSE} then zero is used.}

\item{scale}{logical. If \code{TRUE} then the weighted standard deviation of each variable is used,
if \code{FALSE} then no scaling is done.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then each value is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{online}{logical. Process observations using an online algorithm.}
}
\value{
An object of the same class and dimension as \code{x} with the rolling scaling and centering.
}
\description{
A function for computing the rolling scaling and centering of time-series data.
}
\details{
If \code{center} is \code{TRUE} then centering is done by subtracting the weighted mean from 
each variable, if \code{FALSE} then zero is used. After centering, if \code{scale} is \code{TRUE} then 
scaling is done by dividing by the weighted standard deviation for each variable if \code{center} is 
\code{TRUE}, and the root mean square otherwise. If \code{scale} is \code{FALSE} then no scaling is 
done.

The denominator used gives an unbiased estimate of the standard deviation, so if the weights are the 
default then the divisor \code{n - 1} is obtained.
}
\examples{
n_vars <- 3
n_obs <- 15
x <- matrix(rnorm(n_obs * n_vars), nrow = n_obs, ncol = n_vars)

# rolling z-scores
result <- roll_scale(x, 5)

# rolling z-scores with exponential decay
weights <- 0.9 ^ (5:1)
result <- roll_scale(x, 5, weights)
}
