% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_pcr}
\alias{roll_pcr}
\title{Rolling Principal Component Regressions}
\usage{
roll_pcr(x, y, width, comps = 1:ncol(x), weights = rep(1, width),
  center_x = TRUE, center_y = TRUE, scale_x = FALSE, scale_y = FALSE,
  min_obs = width, complete_obs = TRUE, na_restore = FALSE,
  parallel_for = c("rows", "cols"))
}
\arguments{
\item{x}{matrix or xts object. Rows are observations and columns are the independent variables.}

\item{y}{vector or xts object. Rows are observations and column is the dependent variable.}

\item{width}{integer. Window size.}

\item{comps}{integer vector. Select a subset of principal components.}

\item{weights}{vector. Weights for each observation within a window.}

\item{center_x}{logical. If \code{TRUE} then the weighted mean of each \code{x} variable is used,
if \code{FALSE} then zero is used.}

\item{center_y}{logical. If \code{TRUE} then the weighted mean of the \code{y} variable is used,
if \code{FALSE} then zero is used.}

\item{scale_x}{logical. If \code{TRUE} then the weighted standard deviation of each \code{x} 
variable is used, if \code{FALSE} then no scaling is done.}

\item{scale_y}{logical. If \code{TRUE} then the weighted standard deviation of the \code{y} 
variable is used, if \code{FALSE} then no scaling is done.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window, 
otherwise result is NA.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then pairwise is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{parallel_for}{character. Executes a "for" loop in which iterations run in parallel by
\code{rows} or \code{cols}.}
}
\value{
A list containing the following components:
\item{coefficients}{An object of the same class and dimension as \code{x} with the rolling coefficients.}
\item{r.squared}{An object of the same class as \code{x} with the rolling r-squareds.}
}
\description{
A parallel function for computing rolling principal component regressions of time-series data.
}
\note{
If users are already taking advantage of parallelism using multithreaded BLAS/LAPACK
libraries, then limit the number of cores in the RcppParallel package to one with the
\code{\link[RcppParallel]{setThreadOptions}} function.
}
\examples{
n_vars <- 10
n_obs <- 1000
x <- matrix(rnorm(n_obs * n_vars), nrow = n_obs, ncol = n_vars)
y <- matrix(rnorm(n_obs), nrow = n_obs, ncol = 1)

# 252-day rolling principal component regression
result <- roll_pcr(x, y, 252, comps = 1)

# Equivalent to 'na.rm = TRUE'
result <- roll_pcr(x, y, 252, comps = 1, min_obs = 1)

# Expanding window
result <- roll_pcr(x, y, n_obs, comps = 1, min_obs = 1)

# Exponential decay
weights <- 0.9 ^ (251:0)
result <- roll_pcr(x, y, 252, comps = 1, weights, min_obs = 1)
}
\seealso{
\code{\link[RcppParallel]{setThreadOptions}} for thread options via RcppParallel.
}

