% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{getQuery}
\alias{getQuery}
\title{Retrieve SQL query from database.
Combination of functions sendQuery(), fetch() and clearResult().
If required, database is automatically connected and disconnected.}
\usage{
getQuery(db, statement, n = -1, ...)
}
\arguments{
\item{db}{rocker object}

\item{statement}{SQL query (\code{SELECT})}

\item{n}{Number of record to be fetched at once. All records will be fetched.}

\item{...}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}}
}
\value{
Records
}
\description{
Retrieve SQL query from database.
Combination of functions sendQuery(), fetch() and clearResult().
If required, database is automatically connected and disconnected.
}
\examples{
db <- rocker::newDB()
rocker::setupSQLite(db)
rocker::connect(db)
rocker::writeTable(db, "mtcars", mtcars)
output <- rocker::getQuery(db, "SELECT * FROM mtcars;")
rocker::disconnect(db)
rocker::unloadDriver(db)
}
