% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDatasets.R
\name{extractTuningParameter}
\alias{extractTuningParameter}
\alias{extractPredefinedTuningParameter}
\title{Extract Tuning Parameters Used In Fitting}
\usage{
extractTuningParameter(
  tuningParameter,
  which = c("rho.e", "rho.sigma.e", "rho.b.diagonal", "rho.sigma.b.diagonal",
    "rho.b.blockDiagonal", "rho.sigma.b.blockDiagonal")
)

extractPredefinedTuningParameter(label, which)
}
\arguments{
\item{tuningParameter}{vector of tuning parameters. The vector is expected
to be of length 6, containing the tuning parameters for rho.e,
rho.sigma.e, rho.b.diagonal, rho.sigma.b.diagonal, rho.b.blockDiagonal and
rho.sigma.b.blockDiagonal. 'rho.b.diagonal' denotes the tuning parameter
to be used for 'rho.b' for models with diagonal random effects covariance
matrix. Names are optional.}

\item{which}{string specifiying which tuning parameter should be extracted.}

\item{label}{label or vector of labels in results. Only predefined labels of
the form 'fitDatasets_rlmer_...' are supported (for others NA is
returned).}
}
\value{
scalar tuning parameter
}
\description{
Methods to extract which tuning parameters have been used for fitting
models. Use \code{extractTuningParameter} for custom configurations and
\code{extractPredefinedTuningParameter} for predefined configurations
provided in this package.
}
\examples{
  extractPredefinedTuningParameter("fitDatasets_rlmer_DAStau", "rho.e")
}
\author{
Manuel Koller
}
