% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simiarlity.R
\name{assess.cluster.similarity}
\alias{assess.cluster.similarity}
\title{Assess Cluster Similarity}
\usage{
assess.cluster.similarity(environment,
  diff.exp.file = "main.datasets.diff.exp.rds",
  cluster.similarity.function = pearson.correlation, label = "pearson",
  rerun = F)
}
\arguments{
\item{environment}{\code{environment} object}

\item{diff.exp.file}{name of differential expression results file}

\item{cluster.similarity.function}{which similarity function to use (either 'pearson.correlation' or '?') Mamie - there was another similarity function using euclidean distance. Do you know where did it go to? Can you replace the '?' with the name of this other function?}

\item{label}{name of the similarity measure to use for the results folder}

\item{rerun}{whether to rerun the analysis or load from cache}
}
\value{
pairwise cluster similarity measures
}
\description{
Assess similarity between pairs of clusters.
}
\examples{
\donttest{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
LCMV1 <- cluster.analysis(LCMV1)
types = rbind(
data.frame(type='Tfh',gene=c('Tcf7','Cxcr5','Bcl6')),
data.frame(type='Th1',gene=c('Cxcr6','Ifng','Tbx21')),
data.frame(type='Tcmp',gene=c('Ccr7','Bcl2','Tcf7')),
data.frame(type='Treg',gene=c('Foxp3','Il2ra')),
data.frame(type='Tmem',gene=c('Il7r','Ccr7')),
data.frame(type='CD8',gene=c('Cd8a')),
data.frame(type='CD4', gene = c("Cd4")),
data.frame(type='Cycle',gene=c('Mki67','Top2a','Birc5'))
)
summarize(LCMV1)
cluster_names <- get.cluster.names(LCMV1, types, min.fold = 1.0, max.Qval = 0.01)
LCMV1 <- set.cluster.names(LCMV1, names = cluster_names)
LCMV2 <- setup_LCMV_example("LCMV2")
LCMV2 <- get.variable.genes(LCMV2, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV2 <- PCA(LCMV2)
LCMV2 <- cluster.analysis(LCMV2)
summarize(LCMV2)
cluster_names <- get.cluster.names(LCMV2, types, min.fold = 1.0, max.Qval = 0.01)
LCMV2 <- set.cluster.names(LCMV2, names = cluster_names)
pooled_env <- setup_pooled_env()
pooled_env <- read.preclustered.datasets(pooled_env)
pooled_env <- PCA(pooled_env, clear.previously.calculated.clustering = F)
summarize(pooled_env, contrast = "datasets")
cluster.similarity <- assess.cluster.similarity(pooled_env)
}
}
