% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_tests.R
\name{multi_cutoff_to_fodr_vec}
\alias{multi_cutoff_to_fodr_vec}
\title{Creates a vector of the centered FODR across different cut-offs}
\usage{
multi_cutoff_to_fodr_vec(robust2sls_object, iteration)
}
\arguments{
\item{robust2sls_object}{A list of \code{"robust2sls"} objects.}

\item{iteration}{An integer >= 0 or the character "convergence" that
determines which iteration is used for the test.}
}
\value{
A numeric vector of the centered FODR values.
}
\description{
\code{multi_cutoff_to_fodr_vec()} takes a list of \code{"robust2sls"} objects
and returns a vector of the centered FODR (sample - expected) for different
values of the cut-off c (equivalently gamma):
\loadmathjax
\mjdeqn{ \sqrt{n}(\widehat{\gamma_{c}} - \gamma_{c}) }{sqrt(n)(gamma_hat - gamma)}
}
\details{
See \code{\link[=outlier_detection]{outlier_detection()}} and
\code{\link[=multi_cutoff]{multi_cutoff()}} for creating an object of class
\code{"robust2sls"} or a list thereof.
}
\keyword{internal}
