      subroutine sds(n,np,nresamp,x,tune,wk,locat,cov,maxres,
     1     nresper,w,z,icent,iwork)
c
c
c  INPUT:  'n' = number  observations (integer);
c         'np' = number of indepent  variables (integer);
c    'nresamp' = mumber of  resamples required (integer), may not be reached 
c                if too many of the subsamples of size 'np', chosen out of 
c                the observed vectors, are in a hyperplane;
c                if nresamp=0, ALL subsamples are taken;  
c          'x' = real (n*np) matrix of observed values;
c      'tune'  = tuning constant used in calculation of weights;
c                by default should be equal to the square root of the 
c                95-percentile of the chi-square distribution with 'np' 
c                 degrees of freedom (real).
c       'seed' = seed for calculating random numbers (real);
c         'wk' = real work vector of length (4*n+np).  On output,
c                wk(1),..,wk(n) contain the weights assigned to
c                each observation; 
c     'maxres' = maximum nunber of  resamples to be performed (integer), 
c                including those which are discarded due to linearly 
c                dependent subsamples.
c        'icent'= if 0 the observations are centered with 0
c
c  OUTPUT:  'locat' = real vector of location parameters, of length
c                     'np';
c             'cov' =  real (np*np) Donoho-Stahel covariance matrix;
c         'nresper' = number of  valid resamples performed (integer).
c               'w' = weights
c               'z' = outlyigness
c
c  NOTE:  all real variables are double precision.
c
      implicit double precision (a-h,o-z)
      double precision locat(np)
      dimension x(n,np),wk(4*n+np),cov(np,np),w(n),z(n), iwork(4*n+np)
      nr=1
      nind=nr+n
      naux=nind+np

      call fseedi()
      call S_weights(n,np,nresamp,x,tune,w,z,locat,wk(nr),iwork(nind),
     1             cov,wk(naux),maxres,nresper,icent)
      call S_donostah(n,np,x,w,locat,cov,icent)
      call fseedo()
      return
      end 


      subroutine S_weights(n,np,nresamp,x,c,w,z,a,b,ind,wk,
     1                   u,maxres,nresper,icent)
      implicit double precision (a-h,o-z)
      dimension x(n,np),z(n),a(np),b(n),w(n),ind(np),u(n)
      dimension wk(np,np)

      k1=(np-1)+(n+1)/2
      k2=(np-1)+(n+2)/2
      z1=dble(k1)
      zn=dble(n)
      z3=(1+(z1/zn))/2
      call S_quntbi(z3, cc)
      do i=1,n
         z(i)=-1.
         enddo
      nresper=0
      if (nresamp.eq.0) then
         call S_all(n,np,nresper,x,a,b,w,z,ind,wk,u,k1,k2,cc,icent)
      else
         k=0
         do while (k.lt.maxres.and.nresper.lt.nresamp)
            k=k+1
            call S_subsamp(n,np,ind)
            call S_process(n,np,nresper,x,a,b,w,z,ind,wk,u,k1,
     +           k2,cc,icent)
          enddo
      endif
      do i=1,n
         call S_rwetml(z(i)/c,w(i))
      enddo
      return
      end


      subroutine S_all(n,np,nresper,x,a,b,w,z,ind,wk,u,k1,k2,cc,icent)
      implicit double precision (a-h,o-z)
      dimension x(n,np),z(n),a(np),b(n),w(n),ind(np),u(n)
      dimension wk(np,np)
      do j=1,np
         ind(j)=j
         enddo
      call S_process(n,np,nresper,x,a,b,w,z,ind,wk,u,k1,k2,cc,icent)
      j=0
      do while (np-j.ge.1)
         if (ind(np-j).eq.n-j) then
            j=j+1
            else
            ind(np-j)=ind(np-j)+1
            do k=np-j+1,np
               ind(k)=ind(k-1)+1
            enddo
            call S_process(n,np,nresper,x,a,b,w,z,ind,
     +           wk,u,k1,k2,cc,icent)
            j=0
         endif
      enddo
      return
      end


      subroutine S_process(n,np,nresper,x,a,b,w,z,ind,wk,
     +     u,k1,k2,cc,icent)
      implicit double precision (a-h,o-z)
      dimension x(n,np),z(n),a(np),b(n),w(n),ind(np),u(n)
      dimension wk(np,np)
      data tola,tolr,big1,big2 /1.d-15, 1.d-8,1.d+2,1.d+15/
      call S_vectora(n,np,x,a,ind,wk,icent,ierr)
      if (ierr.eq.0) then
         nresper=nresper+1
         do i=1,n
            b(i)=0.
            do j=1,np
               b(i)=b(i)+x(i,j)*a(j)
            enddo
         enddo
         bmed=0.0d0
         if(icent.ne.0) bmed=S_amed(b,n,u)
         do i=1,n
            w(i)=abs(b(i)-bmed)
         enddo
         ww=0
         do i=1,n
            ww=ww+w(i)
         enddo
         ww=ww/n         
         if(ww.ge.tola) then
            call S_sort(w,n,1)
            bmad=(w(k1)+w(k2))/2
            bmad=bmad/cc 
            if(bmad.ge.tolr *ww) then
               do i=1,n
                   aux=abs(b(i)-bmed)/bmad
                   if (aux.gt.z(i)) z(i)=aux
               enddo
               else
               do i=1,n
                  if(abs(b(i)-bmed).gt. big1*bmad) z(i)=big2
               enddo
            endif
         endif
      endif
      return
      end


      subroutine S_vectora(n,np,x,a,ind,wk,icent,ierr)
      implicit double precision (a-h,o-z)
      dimension x(n,np),a(np),ind(np),wk(np,np)
      do k=1,np
         do j=1,np
            wk(j,k)=x(ind(k),j)
         enddo
      enddo
      call S_direc(wk,np,np,icent,ierr,a)
      return
      end


      subroutine S_donostah(n,np,x,w,locat,cov,icent)
      implicit double precision (a-h,o-z)
      double precision locat(np)
      dimension x(n,np),w(n),cov(np,np)
      sumw=0.
      sumw2=0.
      do i=1,n
         sumw=sumw+w(i)
         sumw2=sumw2+w(i)*w(i)
      enddo
      do j=1,np
         locat(j)=.0
      enddo
      if(icent.eq.1)then
         do j=1,np
            locat(j)=0.
            do i=1,n
               locat(j)=locat(j)+w(i)*x(i,j)
            enddo
            locat(j)=locat(j)/sumw
         enddo
      endif
      do j=1,np
         do k=1,np
            cov(j,k)=0.
            do i=1,n
               cov(j,k)=cov(j,k)+w(i)*(x(i,j)-locat(j))*
     1         w(i)*(x(i,k)-locat(k))
            enddo
            cov(j,k)=cov(j,k)/sumw2
         enddo
      enddo
      return
      end


      subroutine S_subsamp(n,np,ind)
      implicit double precision (a-h,o-z)
      dimension ind(np)
      en=dble(n)
      call splusrunif(RND)
      ind(1)=int(en*RND+1.)
      if (np.eq.1) return
      k=2
   10 call splusrunif(RND)
      ind(k)=int(en*RND+1.)
      do i=1,k-1
         if (ind(i).eq.ind(k)) go to 10
      enddo
      if (k.eq.np) return
      k=k+1
      go to 10
      end

                                                                 
      double precision function S_amed(z,n,aux)
      implicit double precision (a-h,o-z)
      DIMENSION Z(n),aux(n)
      DO 100 I=1,N                                                  
  100 AUX(I)=Z(I)                                                   
      CALL S_SORT (AUX,N,1)                                           
      I=N/2                                                         
      K=I*2                                                         
      S_amed=AUX(I+1)                                                 
      IF (k.GE.N) S_amed=(S_amed+AUX(I))/2.                             
      RETURN                                                        
      END

      SUBROUTINE S_SORT (A,N,SWITCH)                                   
      implicit double precision (a-h,o-z)
      DIMENSION A(n)                                               
      INTEGER SWITCH                                                 
      IF (N.LE.1) GO TO 999                                          
      M=1                                                            
106   M=M+M                                                          
      IF(M.LE.N) GO TO 106                                           
      M=M-1                                                          
994    M=M/2                                                         
      IF (M.EQ.0) GO TO 999                                          
      KK=N-M                                                         
      J=1                                                            
992   I=J                                                            
996   IM=I+M                                                         
      IF(SWITCH) 810,810,800                                         
800    IF (A(I).GT.A(IM)) GO TO 110                                 
      GO TO 995                                                     
810    IF(A(I).LT.A(IM)) GO TO 110                                  
995   J=J+1                                                         
      IF(J.GT.KK) GO TO 994                                         
      GO TO 992                                                     
110   TEMP=A(I)                                                     
      A(I)=A(IM)                                                    
      A(IM)=TEMP                                                    
       I=I-M                                                        
      IF (I.LT.1) GO TO 995                                         
      GO TO 996                                                     
999    RETURN                                                       
      END           


	double precision function S_dprodd(x,y,nn)
	implicit double precision (a-h,o-z)
	dimension x(nn), y(nn)
	S_dprodd=0.
	do  i=1,nn
	   S_dprodd=S_dprodd+x(i)*y(i)
            enddo
	return
	end


	 double precision function S_robust_dnorm(x,nn)
	implicit double precision (a-h,o-z)
	dimension x(nn)
	S_robust_dnorm=S_dprodd(x,x,nn)
            S_robust_dnorm=dsqrt(S_robust_dnorm)
	return
	end


	subroutine S_xnorma(x,nn,ierr,tol)
        implicit double precision (a-h,o-z)
        dimension x(nn)
        ierr=1
        dn=S_robust_dnorm(x,nn)
        if (dn.le.tol) then
           ierr=1
           return
        else
           ierr=0
        endif
        do  i=1,nn
           x(i)=x(i)/dn
        enddo
        return
        end


	subroutine S_orthog(xx,nn,mm,nmain,ierr)
        implicit double precision (a-h,o-z)
        dimension xx(nmain,mm)
        data tola,tolr /1.d-15, 1.d-8/
C In original code tolb was never initialized (was 0 on Solaris, random on HP)
        tolb = tola
        do  j=1,mm
           call  S_xnorma(xx(1,j),nn,ierr,tola)
           if (ierr.gt.0) return
        enddo
        mm1=mm-1
        do  j=1,mm1
           call  S_xnorma(xx(1,j),nn,ierr,tolr)
           if (ierr.ne.0) return
           j1=j+1
           do k=j1,mm
              dp=S_dprodd(xx(1,j),xx(1,k),nn)
              do  i=1,nn
                 xx(i,k)=xx(i,k)-xx(i,j)*dp
              enddo
           enddo
        enddo
	call  S_xnorma(xx(1,mm),nn,ierr,tolb)
C       if (ierr .ne. 0) write(*,*) 'S_xnorma(...,tolb) failed!'
	return
	end


	subroutine S_ortdir(xx,mm,nmain,dire)
        implicit double precision (a-h,o-z)
        dimension xx(nmain,1), dire(mm)
        tol=1./dsqrt(dble(mm))
        mm1=mm-1
        do  k=1,mm
           do  i=1,mm
              dire(i)=0
              do  j=1,mm1
                 dire(i)=dire(i)-xx(i,j)*xx(k,j)
              enddo
           enddo 
           dire(k)=dire(k)+1
           dn=S_robust_dnorm(dire,mm)
           if (dn.ge.tol) goto 40
        enddo
40      do  i=1,mm
           dire(i)=dire(i)/dn
        enddo
        return
        end


        subroutine S_direc(xx,mm,nmain,icent,ierr,dire)
        implicit double precision (a-h,o-z)
        dimension xx(nmain,mm), dire(mm)
        mm1=mm
        if (icent.ne.0)then
           mm1=mm-1
           do  k=1,mm1
              do  i=1,mm
                 xx(i,k)=xx(i,k)-xx(i,mm)
              enddo
           enddo
        endif
        call S_orthog(xx,mm,mm1,nmain,ierr)
        if (ierr.eq.0) call S_ortdir(xx,mm,nmain,dire)
        return
        end
