% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{plus-.fData}
\alias{+.fData}
\alias{-.fData}
\alias{plus-.fData}
\title{Operator \code{+} and \code{-} for \code{fData} objects}
\usage{
\method{+}{fData}(fD, A)

\method{-}{fData}(fD, A)
}
\arguments{
\item{fD}{the univariate functional dataset in form of \code{fData} object.}

\item{A}{either an \code{fData} object, defined on the very same grid of
\code{fD}, or a 1D data structure (such as 1D array or raw
numeric vector), or a 2D data structure (such as 2D array or raw numeric
matrix ), that specifies the second term of the sum.
In case of a 1D data structure, the sum is performed element-wise between
each element of  \code{fD} and \code{A}, and \code{A} must have length
\code{P}, size of \code{fD}'s grid.
In case of a 2D data structure, the sum is performed element-wise between
corresponding elements of \code{fD} and \code{A}'s rows. In this case,
\code{A} must have \code{P} columns, as the size of \code{fD}'s grid.}
}
\value{
The function returns an \code{fData} object, whose function values
have undergone the sum/difference.
}
\description{
These methods provide operators \code{+} and \code{-} to perform sums
or differences between an \code{fData} object and either another
\code{fData} object or other compliant data structures, like matrices or
vectors or arrays, representing the pointwise measurements of the second
term of the  sum.
}
\details{
If the second term of the operation is an \code{fData} object, it must be
defined over the same grid as the first.
}
\examples{
fD = fData( seq( 0, 1, length.out = 10 ),
            values = matrix( seq( 1, 10 ),
                             nrow = 21, ncol = 10, byrow = TRUE ) )
fD + 1 : 10

fD + array( 1, dim = c( 1, 10 ) )

fD + fD

fD = fData( seq( 0, 1, length.out = 10 ),
            values = matrix( seq( 1, 10 ),
                             nrow = 21, ncol = 10, byrow = TRUE ) )
fD - 2 : 11

fD - array( 1, dim = c( 1, 10 ) )

fD - fD

}

