% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gefs.R
\name{gefs}
\alias{gefs}
\alias{gefs_CONNECT}
\alias{gefs_GET}
\alias{gefs_latitudes}
\alias{gefs_longitudes}
\alias{gefs_ensembles}
\alias{gefs_times}
\alias{gefs_variables}
\alias{gefs_dimensions}
\alias{gefs_dimension_values}
\title{Get GEFS ensemble forecast data for a specific lat/lon.}
\usage{
gefs(var, lat, lon, ...)

gefs_CONNECT(date = format(Sys.time(), "\%Y\%m\%d"),
  forecast_time = c("0000", "0600", "1200", "1800"))

gefs_GET(var, lat = NULL, lon = NULL, ens = NULL, time = NULL,
  date = format(Sys.time(), "\%Y\%m\%d"), forecast_time = c("0000",
  "0600", "1200", "1800"), ens_idx = NULL, time_idx = NULL,
  dims = NULL, raw = FALSE, ...)

gefs_latitudes(...)

gefs_longitudes(...)

gefs_ensembles(...)

gefs_times(...)

gefs_variables(...)

gefs_dimensions(var = NULL, ...)

gefs_dimension_values(dim, var = NULL, ...)
}
\arguments{
\item{var}{the variable to get. Must be one of the variables listed in
\code{gefs_variables()}.}

\item{lat}{the latitude. Values must be sequential and are rounded to the
nearest GEFS available latitude.}

\item{lon}{the longitude. Values must be sequential and are rounded to the
nearest GEFS available longitude.}

\item{...}{for \code{gefs()}, additional parameters passed to the
connection, for other functions, passed on to
\code{gefs_dimension_values()}}

\item{date}{A date/string formatted as YYYYMMDD.}

\item{forecast_time}{a string indicating which time of day UTC the
forecast is from. Options are "0000", "0600", "1200", "1800".}

\item{ens, ens_idx}{sequential list of ensembles to fetch. Default is all 21.
Note that the ensembles are labelled 0-20, so ens_idx=1:3 will return
ensembles 0, 1, and 2.}

\item{time, time_idx}{sequential list of time increments to return. List is the
index of times, which are in 6 hour increments. (e.g. c(1,2) fetches the
6 and 12 hour forecast.)}

\item{dims}{(not implemented) indices for additional dimensions to be
included between lat, lon, ens, and time.}

\item{raw}{logical to indicate whether to return raw data matrix or
reshaped data frame.}

\item{dim}{(character) the dimension to fetch values for.}
}
\value{
a list containing metadata and accompanying data frame of
forecast values. If lat/lon are not specified, the $data is an
unprocessed matrix.
}
\description{
Fetches GEFS forecast data for every 6 hours out to 384 hours past
selected date. GEFS is an ensemble of 21 models that can be
summarized to estimate likelihoods of forecasts.
}
\examples{
\dontrun{

#avialable latitudes and longitudes
gefs_latitudes()
gefs_longitudes()

#get a list of all gefs variables
gefs_variables()

#All GEFS dimensions
gefs_dimensions()

#values for a specific dimension
gefs_dimension_values("height_above_ground")

#example location.
lat <- 46.28125
lon <- -118.2188

#Get forecast for a certain variable.
forecast <- gefs("Total_precipitation_surface_6_Hour_Accumulation_ens",
  lat, lon, ens = 0, time = 12)

#Fetch a different date (available up to 10 days prior to today)
forecast_yesterday_prec <- gefs(
   "Total_precipitation_surface_6_Hour_Accumulation_ens",
   lat, lon, ens = 1, time = 6, date=format(as.Date(Sys.time()) - 1, "\%Y\%m\%d"))

#specific ensemble and times, for the 1800 forecast.
# here ensembles 1-3 (ensembles are numbered starting with 0)
# and two time periods: c(1800, 2400)
date <- format(as.Date(Sys.time()) - 1, "\%Y\%m\%d")
var <- "Temperature_height_above_ground_ens"
gefs(var, lat, lon, date = date, forecast_time = "1800", ens=1:3,
  time=6*(3:4))

#One ensemble, all latitudes and longitudes (this is a big file) for the
# next 3 days.
# gefs(var, ens=1, time=6*(1:12))
}

}
\references{
\itemize{
\item Data description - \url{http://bit.ly/noaagefs}.
\item Adapted from Python code written by Von P. Walden, Washington State
University
}
}
\author{
Nicholas Potter \email{potterzot@gmail.com}
}
