% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tornadoes.R
\name{tornadoes}
\alias{tornadoes}
\title{Get NOAA tornado data.}
\usage{
tornadoes(overwrite = TRUE, ...)
}
\arguments{
\item{overwrite}{(logical) To overwrite the path to store files in or not,
Default: \code{TRUE}}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET} (optional)}
}
\value{
A Spatial object is returned of class SpatialLinesDataFrame.
}
\description{
This function gets spatial paths of tornadoes from NOAA's National Weather
Service Storm Prediction Center Severe Weather GIS web page.
}
\section{File storage}{

We use \pkg{rappdirs} to store files, see
\code{\link[rappdirs:user_cache_dir]{rappdirs::user_cache_dir()}} for how
we determine the directory on your machine to save files to, and run
\code{rappdirs::user_cache_dir("rnoaa/tornadoes")} to get that directory.
}

\examples{
\dontrun{
shp <- tornadoes()
library('sp')
if (interactive()) {
  # may take 10 sec or so to render 
  plot(shp)
}
}
}
\references{
https://www.spc.noaa.gov/gis/svrgis/
}
