context("Test gridCoords")
test_that("Parameters are not valid", {
    expect_error(gridCoords("NZ12", "inches"), "'arg' should be one of*")
    expect_error(gridCoords("NZ123", "km"), "must be an even number of digits")
    expect_error(gridCoords("NZ123-", "m"), "not a valid grid reference string")
    expect_error(gridCoords("N123"), "must be an even number of digits")
    expect_error(gridCoords("A12"), "not a valid grid reference string")
    expect_error(gridCoords("PZ1234"), "not a valid grid reference string")
    expect_error(gridCoords("NZ12SW"), "not a valid grid reference string")
})

test_that("Conversion works as expected", {
    expect_that(gridCoords("NZ1265")$system == "OSGB", is_true())
    expect_that(gridCoords("NZ1265")$x == 412, is_true())
    expect_that(gridCoords("NZ1265")$y == 565, is_true())
    expect_that(gridCoords("NZ1265")$precision == 1000, is_true())
    expect_that(gridCoords("NZ1265")$units == "km", is_true())
    expect_that(gridCoords("NZ123654", "m")$system == "OSGB", is_true())
    expect_that(gridCoords("NZ123654", "m")$x == 412300, is_true())
    expect_that(gridCoords("NZ123654", "m")$y == 565400, is_true())
    expect_that(gridCoords("NZ123654", "m")$precision == 100, is_true())
    expect_that(gridCoords("NZ123654", "m")$units == "m", is_true())
    expect_that(gridCoords("R12")$system == "OSNI", is_true())
    expect_that(gridCoords("R12")$x == 110, is_true())
    expect_that(gridCoords("R12")$y == 120, is_true())
    expect_that(gridCoords("R12")$precision == 10000, is_true())
    expect_that(gridCoords("R12", "km")$units == "km", is_true())
    expect_that(gridCoords("TL29R")$x == 526, is_true())
    expect_that(gridCoords("TL29R", "m")$y == 292000, is_true())
    expect_that(gridCoords("TL29R")$precision == 2000, is_true())
})
    