% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_predict_nested_partial_dependencies.R
\name{rmw_predict_nested_partial_dependencies}
\alias{rmw_predict_nested_partial_dependencies}
\title{Function to calculate partial dependencies from a random forest models using 
a nested tibble.}
\usage{
rmw_predict_nested_partial_dependencies(
  df_nest,
  variables = NA,
  n_cores = NA,
  training_only = TRUE,
  rename = FALSE,
  verbose = FALSE,
  progress = FALSE
)
}
\arguments{
\item{df_nest}{Nested tibble created by \code{\link{rmw_model_nested_sets}}.}

\item{variables}{Vector of variables to calculate partial dependencies for.}

\item{n_cores}{Number of CPU cores to use for the model calculations.}

\item{training_only}{Should only the training set be used for prediction?}

\item{rename}{Within the \code{partial_dependencies} nested tibble, should 
the generic \code{"variable"} name be renamed to \code{"variable_model"}. 
This is useful when \code{"variable"} has been used as a pollutant identifier.}

\item{verbose}{Should the function give messages?}

\item{progress}{Should a progress bar be displayed?}
}
\value{
Nested tibble.
}
\description{
Function to calculate partial dependencies from a random forest models using 
a nested tibble.
}
\seealso{
\code{\link{rmw_nest_for_modelling}}, 
\code{\link{rmw_model_nested_sets}}, \code{\link{rmw_partial_dependencies}}
}
\author{
Stuart K. Grange
}
