% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanMisc.r
\name{pdensityContour}
\alias{pdensityContour}
\title{pdensityContour}
\usage{
pdensityContour(
  x,
  y,
  method = c("ellipse", "kernel"),
  prob = 0.95,
  otherprob = c(0.01, 0.1, 0.25, 0.5, 0.75, 0.9),
  h = c(1.3 * MASS::bandwidth.nrd(x), 1.3 * MASS::bandwidth.nrd(y)),
  n = 70,
  pl = FALSE
)
}
\arguments{
\item{x}{a numeric vector}

\item{y}{a numeric vector the same length of x}

\item{method}{defaults to \code{'ellipse'}, can be set to \code{'kernel'}}

\item{prob}{main probability coverage (the only one for \code{method='ellipse'})}

\item{otherprob}{vector of other probability coverages for \code{method='kernel'}}

\item{h}{vector of bandwidths for x and y.  See \code{\link[MASS:kde2d]{MASS::kde2d()}}.}

\item{n}{number of grid points in each direction, defaulting to normal reference bandwidth (see \code{bandwidth.nrd}).}

\item{pl}{set to \code{TRUE} to plot contours}
}
\value{
a 2-column matrix with x and y coordinates unless \code{pl=TRUE} in which case a \code{ggplot2} graphic is returned
}
\description{
Bivariate Posterior Contour
}
\details{
Computes coordinates of a highest density contour containing a given probability volume given a sample from a continuous bivariate distribution, and optionally plots.  The default method assumes an elliptical shape, but one can optionally use a kernel density estimator.
Code adapted from \code{embbook::HPDregionplot}.  See \url{http://www.sumsar.net/blog/2014/11/how-to-summarize-a-2d-posterior-using-a-highest-density-ellipse}.
}
\author{
Ben Bolker and Frank Harrell
}
